/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest.client.request;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.apicurio.registry.rest.client.request.ErrorHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.http.HttpResponse;
import java.util.function.Supplier;

public class BodyHandler<W>
implements HttpResponse.BodyHandler<Supplier<W>> {
    private final TypeReference<W> wClass;
    private static final ObjectMapper mapper = new ObjectMapper();

    public BodyHandler(TypeReference<W> wClass) {
        this.wClass = wClass;
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    @Override
    public HttpResponse.BodySubscriber<Supplier<W>> apply(HttpResponse.ResponseInfo responseInfo) {
        return BodyHandler.asJSON(this.wClass, responseInfo);
    }

    public static <W> HttpResponse.BodySubscriber<Supplier<W>> asJSON(TypeReference<W> targetType, HttpResponse.ResponseInfo responseInfo) {
        HttpResponse.BodySubscriber<InputStream> upstream = HttpResponse.BodySubscribers.ofInputStream();
        return HttpResponse.BodySubscribers.mapping(upstream, inputStream -> BodyHandler.toSupplierOfType(inputStream, targetType, responseInfo));
    }

    public static <W> Supplier<W> toSupplierOfType(InputStream body, TypeReference<W> targetType, HttpResponse.ResponseInfo responseInfo) {
        return () -> {
            try {
                if (BodyHandler.isFailure(responseInfo)) {
                    throw ErrorHandler.handleErrorResponse(body, responseInfo);
                }
                String typeName = targetType.getType().getTypeName();
                if (typeName.contains("InputStream")) {
                    return body;
                }
                if (typeName.contains("Void")) {
                    return null;
                }
                return mapper.readValue(body, targetType);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    private static boolean isFailure(HttpResponse.ResponseInfo responseInfo) {
        return responseInfo.statusCode() / 100 != 2;
    }
}

