/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest.client.request;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.apicurio.registry.rest.client.exception.ExceptionMapper;
import io.apicurio.registry.rest.client.exception.ForbiddenException;
import io.apicurio.registry.rest.client.exception.NotAuthorizedException;
import io.apicurio.registry.rest.client.exception.RestClientException;
import io.apicurio.registry.rest.client.request.BodyHandler;
import io.apicurio.registry.rest.v2.beans.Error;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.keycloak.authorization.client.util.HttpResponseException;

public class ErrorHandler {
    private static final ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private static final Logger logger = Logger.getLogger(BodyHandler.class.getName());

    public static RestClientException handleErrorResponse(InputStream body, HttpResponse.ResponseInfo responseInfo) {
        try {
            if (responseInfo.statusCode() == 401) {
                Error error = new Error();
                error.setErrorCode(Integer.valueOf(responseInfo.statusCode()));
                throw new NotAuthorizedException(error);
            }
            if (responseInfo.statusCode() == 403) {
                Error error = new Error();
                error.setErrorCode(Integer.valueOf(responseInfo.statusCode()));
                throw new ForbiddenException(error);
            }
            Error error = (Error)mapper.readValue(body, Error.class);
            return ExceptionMapper.map(new RestClientException(error));
        }
        catch (Exception e) {
            Throwable cause = ErrorHandler.extractRootCause(e);
            if (cause instanceof RestClientException) {
                throw (RestClientException)cause;
            }
            Error error = new Error();
            error.setMessage(cause.getMessage());
            error.setErrorCode(Integer.valueOf(0));
            logger.log(Level.SEVERE, "Unkown client exception", cause);
            return new RestClientException(error);
        }
    }

    public static RestClientException parseInputSerializingError(JsonProcessingException ex) {
        Error error = new Error();
        error.setName(((Object)((Object)ex)).getClass().getSimpleName());
        error.setDetail(ex.getMessage());
        error.setMessage("Error trying to parse request body");
        return new RestClientException(new Error());
    }

    public static RestClientException parseError(Exception ex) {
        if (ex instanceof HttpResponseException) {
            HttpResponseException hre = (HttpResponseException)((Object)ex);
            Error error = new Error();
            error.setErrorCode(Integer.valueOf(hre.getStatusCode()));
            error.setMessage(hre.getMessage());
            error.setDetail(hre.getReasonPhrase());
            if (hre.getStatusCode() == 401) {
                return new NotAuthorizedException(error);
            }
            return new RestClientException(error);
        }
        Error error = new Error();
        error.setName(ex.getClass().getSimpleName());
        return new RestClientException(error);
    }

    private static Throwable extractRootCause(Throwable e) {
        Throwable cause = null;
        while (true) {
            if (cause == null) {
                cause = e;
                continue;
            }
            if (cause.getCause() == null || cause.getCause().equals(cause)) break;
            cause = cause.getCause();
        }
        if (cause.getSuppressed().length != 0) {
            cause = cause.getSuppressed()[0];
        }
        return cause;
    }
}

