/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest.client;

import io.apicurio.registry.rest.v2.beans.ArtifactMetaData;
import io.apicurio.registry.rest.v2.beans.ArtifactSearchResults;
import io.apicurio.registry.rest.v2.beans.EditableMetaData;
import io.apicurio.registry.rest.v2.beans.IfExists;
import io.apicurio.registry.rest.v2.beans.LogConfiguration;
import io.apicurio.registry.rest.v2.beans.NamedLogConfiguration;
import io.apicurio.registry.rest.v2.beans.RoleMapping;
import io.apicurio.registry.rest.v2.beans.Rule;
import io.apicurio.registry.rest.v2.beans.SortBy;
import io.apicurio.registry.rest.v2.beans.SortOrder;
import io.apicurio.registry.rest.v2.beans.UpdateState;
import io.apicurio.registry.rest.v2.beans.UserInfo;
import io.apicurio.registry.rest.v2.beans.VersionMetaData;
import io.apicurio.registry.rest.v2.beans.VersionSearchResults;
import io.apicurio.registry.types.ArtifactType;
import io.apicurio.registry.types.RoleType;
import io.apicurio.registry.types.RuleType;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

public interface RegistryClient {
    public InputStream getLatestArtifact(String var1, String var2);

    public ArtifactMetaData updateArtifact(String var1, String var2, String var3, String var4, String var5, String var6, InputStream var7);

    default public ArtifactMetaData updateArtifact(String groupId, String artifactId, String version, String artifactName, String artifactDescription, InputStream data) {
        return this.updateArtifact(groupId, artifactId, version, artifactName, artifactDescription, null, data);
    }

    default public ArtifactMetaData updateArtifact(String groupId, String artifactId, String version, InputStream data) {
        return this.updateArtifact(groupId, artifactId, version, null, null, null, data);
    }

    default public ArtifactMetaData updateArtifact(String groupId, String artifactId, InputStream data) {
        return this.updateArtifact(groupId, artifactId, null, null, null, null, data);
    }

    public void deleteArtifact(String var1, String var2);

    public ArtifactMetaData getArtifactMetaData(String var1, String var2);

    public void updateArtifactMetaData(String var1, String var2, EditableMetaData var3);

    public VersionMetaData getArtifactVersionMetaDataByContent(String var1, String var2, Boolean var3, String var4, InputStream var5);

    default public VersionMetaData getArtifactVersionMetaDataByContent(String groupId, String artifactId, Boolean canonical, InputStream data) {
        return this.getArtifactVersionMetaDataByContent(groupId, artifactId, canonical, null, data);
    }

    default public VersionMetaData getArtifactVersionMetaDataByContent(String groupId, String artifactId, InputStream data) {
        return this.getArtifactVersionMetaDataByContent(groupId, artifactId, null, null, data);
    }

    public List<RuleType> listArtifactRules(String var1, String var2);

    public void createArtifactRule(String var1, String var2, Rule var3);

    public void deleteArtifactRules(String var1, String var2);

    public Rule getArtifactRuleConfig(String var1, String var2, RuleType var3);

    public Rule updateArtifactRuleConfig(String var1, String var2, RuleType var3, Rule var4);

    public void deleteArtifactRule(String var1, String var2, RuleType var3);

    public void updateArtifactState(String var1, String var2, UpdateState var3);

    public void testUpdateArtifact(String var1, String var2, String var3, InputStream var4);

    default public void testUpdateArtifact(String groupId, String artifactId, InputStream data) {
        this.testUpdateArtifact(groupId, artifactId, null, data);
    }

    public InputStream getArtifactVersion(String var1, String var2, String var3);

    public VersionMetaData getArtifactVersionMetaData(String var1, String var2, String var3);

    public void updateArtifactVersionMetaData(String var1, String var2, String var3, EditableMetaData var4);

    public void deleteArtifactVersionMetaData(String var1, String var2, String var3);

    public void updateArtifactVersionState(String var1, String var2, String var3, UpdateState var4);

    public VersionSearchResults listArtifactVersions(String var1, String var2, Integer var3, Integer var4);

    public VersionMetaData createArtifactVersion(String var1, String var2, String var3, String var4, String var5, String var6, InputStream var7);

    default public VersionMetaData createArtifactVersion(String groupId, String artifactId, String version, String artifactName, String artifactDescription, InputStream data) {
        return this.createArtifactVersion(groupId, artifactId, version, artifactName, artifactDescription, null, data);
    }

    default public VersionMetaData createArtifactVersion(String groupId, String artifactId, String version, InputStream data) {
        return this.createArtifactVersion(groupId, artifactId, version, null, null, null, data);
    }

    public ArtifactSearchResults listArtifactsInGroup(String var1, SortBy var2, SortOrder var3, Integer var4, Integer var5);

    default public ArtifactSearchResults listArtifactsInGroup(String groupId) {
        return this.listArtifactsInGroup(groupId, null, null, null, null);
    }

    public ArtifactMetaData createArtifact(String var1, String var2, String var3, ArtifactType var4, IfExists var5, Boolean var6, String var7, String var8, String var9, InputStream var10);

    default public ArtifactMetaData createArtifact(String groupId, String artifactId, String version, ArtifactType artifactType, IfExists ifExists, Boolean canonical, String artifactName, String artifactDescription, InputStream data) {
        return this.createArtifact(groupId, artifactId, version, artifactType, ifExists, canonical, artifactName, artifactDescription, null, data);
    }

    default public ArtifactMetaData createArtifact(String groupId, String artifactId, String version, ArtifactType artifactType, IfExists ifExists, Boolean canonical, InputStream data) {
        return this.createArtifact(groupId, artifactId, version, artifactType, ifExists, canonical, null, null, null, data);
    }

    default public ArtifactMetaData createArtifact(String groupId, String artifactId, InputStream data) {
        return this.createArtifact(groupId, artifactId, null, null, null, null, null, null, null, data);
    }

    default public ArtifactMetaData createArtifact(String groupId, String artifactId, String version, InputStream data) {
        return this.createArtifact(groupId, artifactId, version, null, null, null, null, null, null, data);
    }

    default public ArtifactMetaData createArtifact(String groupId, String artifactId, ArtifactType artifactType, InputStream data) {
        return this.createArtifact(groupId, artifactId, null, artifactType, null, null, null, null, null, data);
    }

    default public ArtifactMetaData createArtifact(String groupId, String artifactId, ArtifactType artifactType, IfExists ifExists, InputStream data) {
        return this.createArtifact(groupId, artifactId, null, artifactType, ifExists, null, null, null, null, data);
    }

    public void deleteArtifactsInGroup(String var1);

    public InputStream getContentById(long var1);

    public InputStream getContentByGlobalId(long var1);

    public InputStream getContentByHash(String var1, Boolean var2);

    default public InputStream getContentByHash(String contentHash) {
        return this.getContentByHash(contentHash, null);
    }

    public ArtifactSearchResults searchArtifacts(String var1, String var2, String var3, List<String> var4, List<String> var5, SortBy var6, SortOrder var7, Integer var8, Integer var9);

    public ArtifactSearchResults searchArtifactsByContent(InputStream var1, SortBy var2, SortOrder var3, Integer var4, Integer var5);

    public List<RuleType> listGlobalRules();

    public void createGlobalRule(Rule var1);

    public void deleteAllGlobalRules();

    public Rule getGlobalRuleConfig(RuleType var1);

    public Rule updateGlobalRuleConfig(RuleType var1, Rule var2);

    public void deleteGlobalRule(RuleType var1);

    public List<NamedLogConfiguration> listLogConfigurations();

    public NamedLogConfiguration getLogConfiguration(String var1);

    public NamedLogConfiguration setLogConfiguration(String var1, LogConfiguration var2);

    public NamedLogConfiguration removeLogConfiguration(String var1);

    public InputStream exportData();

    public void importData(InputStream var1);

    public List<RoleMapping> listRoleMappings();

    public void createRoleMapping(RoleMapping var1);

    public RoleMapping getRoleMapping(String var1);

    public void updateRoleMapping(String var1, RoleType var2);

    public void deleteRoleMapping(String var1);

    public UserInfo getCurrentUserInfo();

    public void setNextRequestHeaders(Map<String, String> var1);

    public Map<String, String> getHeaders();
}

