/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest.client;

import io.apicurio.registry.rest.client.RegistryClient;
import io.apicurio.registry.rest.client.impl.ErrorHandler;
import io.apicurio.registry.rest.client.impl.RegistryClientImpl;
import io.apicurio.rest.client.auth.Auth;
import io.apicurio.rest.client.error.RestClientErrorHandler;
import io.apicurio.rest.client.spi.ApicurioHttpClient;
import io.apicurio.rest.client.spi.ApicurioHttpClientProvider;
import io.apicurio.rest.client.spi.ApicurioHttpClientServiceLoader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class RegistryClientFactory {
    private static final AtomicReference<ApicurioHttpClientProvider> providerReference = new AtomicReference();
    private static final ApicurioHttpClientServiceLoader serviceLoader = new ApicurioHttpClientServiceLoader();
    private static final Map<String, String> KEYS_TO_TRANSLATE;
    private static final String BASE_PATH = "apis/registry/v2/";

    public static RegistryClient create(ApicurioHttpClient apicurioHttpClient) {
        return new RegistryClientImpl(apicurioHttpClient);
    }

    public static RegistryClient create(String basePath) {
        return RegistryClientFactory.create(basePath, Collections.emptyMap(), null);
    }

    public static RegistryClient create(String baseUrl, Map<String, Object> configs) {
        return RegistryClientFactory.create(baseUrl, configs, null);
    }

    public static RegistryClient create(String baseUrl, Map<String, Object> configs, Auth auth) {
        ApicurioHttpClientProvider p = providerReference.get();
        if (p == null) {
            providerReference.compareAndSet(null, RegistryClientFactory.resolveProviderInstance());
            p = providerReference.get();
        }
        if (configs.isEmpty()) {
            configs = Map.of("apicurio.registry.rest.client.auto-base-path", BASE_PATH);
        } else if (!configs.containsKey("apicurio.registry.rest.client.auto-base-path")) {
            configs.put("apicurio.registry.rest.client.auto-base-path", BASE_PATH);
        }
        Map<String, Object> processedConfigs = RegistryClientFactory.processConfiguration(configs);
        return new RegistryClientImpl(p.create(baseUrl, processedConfigs, auth, (RestClientErrorHandler)new ErrorHandler()));
    }

    private static Map<String, Object> processConfiguration(Map<String, Object> configs) {
        HashMap<String, Object> processedConfigs = new HashMap<String, Object>();
        configs.forEach((key, value) -> processedConfigs.put(KEYS_TO_TRANSLATE.getOrDefault(key, (String)key), value));
        return processedConfigs;
    }

    public static boolean setProvider(ApicurioHttpClientProvider provider) {
        return providerReference.compareAndSet(null, provider);
    }

    private static ApicurioHttpClientProvider resolveProviderInstance() {
        return (ApicurioHttpClientProvider)serviceLoader.providers(true).next();
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("apicurio.registry.request.headers.", "apicurio.rest.request.headers.");
        map.put("apicurio.registry.request.ssl.truststore", "apicurio.rest.request.headers.");
        map.put("apicurio.registry.request.ssl.truststore.location", "apicurio.rest.request.headers.");
        map.put("apicurio.registry.request.ssl.truststore.type", "apicurio.rest.request.headers.");
        map.put("apicurio.registry.request.ssl.truststore.password", "apicurio.rest.request.headers.");
        map.put("apicurio.registry.request.ssl.keystore", "apicurio.rest.request.headers.");
        map.put("apicurio.registry.request.ssl.keystore.location", "apicurio.rest.request.headers.");
        map.put("apicurio.registry.request.ssl.keystore.type", "apicurio.rest.request.headers.");
        map.put("apicurio.registry.request.ssl.keystore.password", "apicurio.rest.request.headers.");
        map.put("apicurio.registry.request.ssl.key.password", "apicurio.rest.request.headers.");
        map.put("apicurio.registry.client.disable-auto-basepath-append", "apicurio.rest.request.headers.");
        map.put("apicurio.registry.rest.client.auto-base-path", "apicurio.rest.client.auto-base-path");
        KEYS_TO_TRANSLATE = Collections.unmodifiableMap(map);
    }
}

