/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest.client;

import io.apicurio.registry.rest.v2.beans.ArtifactContent;
import io.apicurio.registry.rest.v2.beans.ArtifactMetaData;
import io.apicurio.registry.rest.v2.beans.ArtifactOwner;
import io.apicurio.registry.rest.v2.beans.ArtifactReference;
import io.apicurio.registry.rest.v2.beans.ArtifactSearchResults;
import io.apicurio.registry.rest.v2.beans.ConfigurationProperty;
import io.apicurio.registry.rest.v2.beans.EditableMetaData;
import io.apicurio.registry.rest.v2.beans.GroupMetaData;
import io.apicurio.registry.rest.v2.beans.GroupSearchResults;
import io.apicurio.registry.rest.v2.beans.IfExists;
import io.apicurio.registry.rest.v2.beans.LogConfiguration;
import io.apicurio.registry.rest.v2.beans.NamedLogConfiguration;
import io.apicurio.registry.rest.v2.beans.RoleMapping;
import io.apicurio.registry.rest.v2.beans.Rule;
import io.apicurio.registry.rest.v2.beans.SortBy;
import io.apicurio.registry.rest.v2.beans.SortOrder;
import io.apicurio.registry.rest.v2.beans.UpdateState;
import io.apicurio.registry.rest.v2.beans.UserInfo;
import io.apicurio.registry.rest.v2.beans.VersionMetaData;
import io.apicurio.registry.rest.v2.beans.VersionSearchResults;
import io.apicurio.registry.types.RoleType;
import io.apicurio.registry.types.RuleType;
import java.io.Closeable;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

public interface RegistryClient
extends Closeable {
    public InputStream getLatestArtifact(String var1, String var2);

    public ArtifactMetaData updateArtifact(String var1, String var2, String var3, String var4, String var5, String var6, InputStream var7);

    public ArtifactMetaData updateArtifact(String var1, String var2, String var3, String var4, String var5, InputStream var6, List<ArtifactReference> var7);

    default public ArtifactMetaData updateArtifact(String groupId, String artifactId, String version, String artifactName, String artifactDescription, InputStream data) {
        return this.updateArtifact(groupId, artifactId, version, artifactName, artifactDescription, null, data);
    }

    default public ArtifactMetaData updateArtifact(String groupId, String artifactId, String version, InputStream data) {
        return this.updateArtifact(groupId, artifactId, version, null, null, null, data);
    }

    default public ArtifactMetaData updateArtifact(String groupId, String artifactId, InputStream data) {
        return this.updateArtifact(groupId, artifactId, null, null, null, null, data);
    }

    public void deleteArtifact(String var1, String var2);

    public ArtifactMetaData getArtifactMetaData(String var1, String var2);

    public ArtifactOwner getArtifactOwner(String var1, String var2);

    public void updateArtifactMetaData(String var1, String var2, EditableMetaData var3);

    public void updateArtifactOwner(String var1, String var2, ArtifactOwner var3);

    public VersionMetaData getArtifactVersionMetaDataByContent(String var1, String var2, Boolean var3, String var4, InputStream var5);

    public VersionMetaData getArtifactVersionMetaDataByContent(String var1, String var2, Boolean var3, ArtifactContent var4);

    default public VersionMetaData getArtifactVersionMetaDataByContent(String groupId, String artifactId, Boolean canonical, InputStream data) {
        return this.getArtifactVersionMetaDataByContent(groupId, artifactId, canonical, null, data);
    }

    default public VersionMetaData getArtifactVersionMetaDataByContent(String groupId, String artifactId, InputStream data) {
        return this.getArtifactVersionMetaDataByContent(groupId, artifactId, null, null, data);
    }

    default public VersionMetaData getArtifactVersionMetaDataByContent(String groupId, String artifactId, ArtifactContent artifactContent) {
        return this.getArtifactVersionMetaDataByContent(groupId, artifactId, null, artifactContent);
    }

    public List<RuleType> listArtifactRules(String var1, String var2);

    public void createArtifactRule(String var1, String var2, Rule var3);

    public void deleteArtifactRules(String var1, String var2);

    public Rule getArtifactRuleConfig(String var1, String var2, RuleType var3);

    public Rule updateArtifactRuleConfig(String var1, String var2, RuleType var3, Rule var4);

    public void deleteArtifactRule(String var1, String var2, RuleType var3);

    public void updateArtifactState(String var1, String var2, UpdateState var3);

    public void testUpdateArtifact(String var1, String var2, String var3, InputStream var4);

    default public void testUpdateArtifact(String groupId, String artifactId, InputStream data) {
        this.testUpdateArtifact(groupId, artifactId, null, data);
    }

    public InputStream getArtifactVersion(String var1, String var2, String var3);

    public VersionMetaData getArtifactVersionMetaData(String var1, String var2, String var3);

    public void updateArtifactVersionMetaData(String var1, String var2, String var3, EditableMetaData var4);

    public void deleteArtifactVersionMetaData(String var1, String var2, String var3);

    public void updateArtifactVersionState(String var1, String var2, String var3, UpdateState var4);

    public VersionSearchResults listArtifactVersions(String var1, String var2, Integer var3, Integer var4);

    public VersionMetaData createArtifactVersion(String var1, String var2, String var3, String var4, String var5, String var6, InputStream var7);

    default public VersionMetaData createArtifactVersion(String groupId, String artifactId, String version, String artifactName, String artifactDescription, InputStream data) {
        return this.createArtifactVersion(groupId, artifactId, version, artifactName, artifactDescription, null, data);
    }

    default public VersionMetaData createArtifactVersion(String groupId, String artifactId, String version, InputStream data) {
        return this.createArtifactVersion(groupId, artifactId, version, null, null, null, data);
    }

    public ArtifactSearchResults listArtifactsInGroup(String var1, SortBy var2, SortOrder var3, Integer var4, Integer var5);

    default public ArtifactSearchResults listArtifactsInGroup(String groupId) {
        return this.listArtifactsInGroup(groupId, null, null, null, null);
    }

    public ArtifactMetaData createArtifact(String var1, String var2, String var3, String var4, IfExists var5, Boolean var6, String var7, String var8, String var9, String var10, String var11, InputStream var12);

    public ArtifactMetaData createArtifact(String var1, String var2, String var3, String var4, IfExists var5, Boolean var6, String var7, String var8, String var9, String var10, String var11, InputStream var12, List<ArtifactReference> var13);

    default public ArtifactMetaData createArtifact(String groupId, String artifactId, String version, String artifactType, IfExists ifExists, Boolean canonical, String artifactName, String artifactDescription, InputStream data) {
        return this.createArtifact(groupId, artifactId, version, artifactType, ifExists, canonical, artifactName, artifactDescription, null, null, null, data);
    }

    default public ArtifactMetaData createArtifact(String groupId, String artifactId, String version, String artifactType, IfExists ifExists, Boolean canonical, InputStream data) {
        return this.createArtifact(groupId, artifactId, version, artifactType, ifExists, canonical, null, null, null, null, null, data);
    }

    default public ArtifactMetaData createArtifact(String groupId, String artifactId, InputStream data) {
        return this.createArtifact(groupId, artifactId, null, null, null, null, null, null, null, null, null, data);
    }

    default public ArtifactMetaData createArtifact(String groupId, String artifactId, InputStream data, List<ArtifactReference> artifactReferences) {
        return this.createArtifact(groupId, artifactId, null, null, null, null, null, null, null, null, null, data, artifactReferences);
    }

    default public ArtifactMetaData createArtifact(String groupId, String artifactId, String artifactType, IfExists ifExists, InputStream data) {
        return this.createArtifact(groupId, artifactId, null, artifactType, ifExists, null, null, null, null, null, null, data);
    }

    default public ArtifactMetaData createArtifact(String groupId, String artifactId, String artifactType, InputStream data) {
        return this.createArtifact(groupId, artifactId, null, artifactType, null, null, null, null, null, null, null, data);
    }

    default public ArtifactMetaData createArtifactWithVersion(String groupId, String artifactId, String version, InputStream data) {
        return this.createArtifact(groupId, artifactId, version, null, null, null, null, null, null, null, null, data);
    }

    public void deleteArtifactsInGroup(String var1);

    public void createArtifactGroup(GroupMetaData var1);

    public void deleteArtifactGroup(String var1);

    public GroupMetaData getArtifactGroup(String var1);

    public GroupSearchResults listGroups(SortBy var1, SortOrder var2, Integer var3, Integer var4);

    public InputStream getContentById(long var1);

    public InputStream getContentByGlobalId(long var1);

    public InputStream getContentByGlobalId(long var1, Boolean var3, Boolean var4);

    public InputStream getContentByHash(String var1, Boolean var2);

    default public InputStream getContentByHash(String contentHash) {
        return this.getContentByHash(contentHash, null);
    }

    default public ArtifactSearchResults searchArtifacts(String group, String name, String description, List<String> labels, List<String> properties, SortBy orderBy, SortOrder order, Integer offset, Integer limit) {
        return this.searchArtifacts(group, name, description, labels, properties, null, null, orderBy, order, offset, limit);
    }

    public ArtifactSearchResults searchArtifacts(String var1, String var2, String var3, List<String> var4, List<String> var5, Long var6, Long var7, SortBy var8, SortOrder var9, Integer var10, Integer var11);

    public ArtifactSearchResults searchArtifactsByContent(InputStream var1, SortBy var2, SortOrder var3, Integer var4, Integer var5);

    @Deprecated
    public List<RuleType> listGlobalRules();

    @Deprecated
    public void createGlobalRule(Rule var1);

    @Deprecated
    public void deleteAllGlobalRules();

    @Deprecated
    public Rule getGlobalRuleConfig(RuleType var1);

    @Deprecated
    public Rule updateGlobalRuleConfig(RuleType var1, Rule var2);

    @Deprecated
    public void deleteGlobalRule(RuleType var1);

    @Deprecated
    public List<NamedLogConfiguration> listLogConfigurations();

    @Deprecated
    public NamedLogConfiguration getLogConfiguration(String var1);

    @Deprecated
    public NamedLogConfiguration setLogConfiguration(String var1, LogConfiguration var2);

    @Deprecated
    public NamedLogConfiguration removeLogConfiguration(String var1);

    @Deprecated
    public InputStream exportData();

    @Deprecated
    public void importData(InputStream var1);

    @Deprecated
    public void importData(InputStream var1, boolean var2, boolean var3);

    @Deprecated
    public List<RoleMapping> listRoleMappings();

    @Deprecated
    public void createRoleMapping(RoleMapping var1);

    @Deprecated
    public RoleMapping getRoleMapping(String var1);

    @Deprecated
    public void updateRoleMapping(String var1, RoleType var2);

    @Deprecated
    public void deleteRoleMapping(String var1);

    public UserInfo getCurrentUserInfo();

    public void setNextRequestHeaders(Map<String, String> var1);

    public Map<String, String> getHeaders();

    public List<ConfigurationProperty> listConfigProperties();

    public void setConfigProperty(String var1, String var2);

    public ConfigurationProperty getConfigProperty(String var1);

    public void deleteConfigProperty(String var1);

    public List<ArtifactReference> getArtifactReferencesByGlobalId(long var1);

    public List<ArtifactReference> getArtifactReferencesByContentId(long var1);

    public List<ArtifactReference> getArtifactReferencesByContentHash(String var1);

    public List<ArtifactReference> getArtifactReferencesByCoordinates(String var1, String var2, String var3);
}

