/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest.client.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.apicurio.registry.rest.client.RegistryClient;
import io.apicurio.registry.rest.client.exception.InvalidArtifactIdException;
import io.apicurio.registry.rest.client.exception.RestClientException;
import io.apicurio.registry.rest.client.request.Parameters;
import io.apicurio.registry.rest.client.request.provider.AdminRequestsProvider;
import io.apicurio.registry.rest.client.request.provider.GroupRequestsProvider;
import io.apicurio.registry.rest.client.request.provider.IdRequestsProvider;
import io.apicurio.registry.rest.client.request.provider.SearchRequestsProvider;
import io.apicurio.registry.rest.client.request.provider.UsersRequestsProvider;
import io.apicurio.registry.rest.v2.beans.ArtifactContent;
import io.apicurio.registry.rest.v2.beans.ArtifactMetaData;
import io.apicurio.registry.rest.v2.beans.ArtifactOwner;
import io.apicurio.registry.rest.v2.beans.ArtifactReference;
import io.apicurio.registry.rest.v2.beans.ArtifactSearchResults;
import io.apicurio.registry.rest.v2.beans.ConfigurationProperty;
import io.apicurio.registry.rest.v2.beans.EditableMetaData;
import io.apicurio.registry.rest.v2.beans.Error;
import io.apicurio.registry.rest.v2.beans.GroupMetaData;
import io.apicurio.registry.rest.v2.beans.GroupSearchResults;
import io.apicurio.registry.rest.v2.beans.IfExists;
import io.apicurio.registry.rest.v2.beans.LogConfiguration;
import io.apicurio.registry.rest.v2.beans.NamedLogConfiguration;
import io.apicurio.registry.rest.v2.beans.RoleMapping;
import io.apicurio.registry.rest.v2.beans.Rule;
import io.apicurio.registry.rest.v2.beans.SortBy;
import io.apicurio.registry.rest.v2.beans.SortOrder;
import io.apicurio.registry.rest.v2.beans.UpdateState;
import io.apicurio.registry.rest.v2.beans.UserInfo;
import io.apicurio.registry.rest.v2.beans.VersionMetaData;
import io.apicurio.registry.rest.v2.beans.VersionSearchResults;
import io.apicurio.registry.types.RoleType;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.utils.ArtifactIdValidator;
import io.apicurio.registry.utils.IoUtil;
import io.apicurio.rest.client.spi.ApicurioHttpClient;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryClientImpl
implements RegistryClient {
    protected final ApicurioHttpClient apicurioHttpClient;
    private static final Logger logger = LoggerFactory.getLogger(RegistryClientImpl.class);

    public RegistryClientImpl(ApicurioHttpClient apicurioHttpClient) {
        this.apicurioHttpClient = apicurioHttpClient;
    }

    @Override
    public InputStream getLatestArtifact(String groupId, String artifactId) {
        return (InputStream)this.apicurioHttpClient.sendRequest(GroupRequestsProvider.getLatestArtifact(this.normalizeGid(groupId), artifactId));
    }

    @Override
    public ArtifactMetaData updateArtifact(String groupId, String artifactId, String version, String artifactName, String artifactDescription, String contentType, InputStream data) {
        Map<String, String> headers = this.headersFrom(version, artifactName, artifactDescription, contentType);
        return (ArtifactMetaData)this.apicurioHttpClient.sendRequest(GroupRequestsProvider.updateArtifact(this.normalizeGid(groupId), artifactId, headers, data));
    }

    @Override
    public ArtifactMetaData updateArtifact(String groupId, String artifactId, String version, String artifactName, String artifactDescription, InputStream data, List<ArtifactReference> references) {
        Map<String, String> headers = this.headersFrom(version, artifactName, artifactDescription, "application/create.extended+json");
        ArtifactContent artifactContent = new ArtifactContent();
        artifactContent.setContent(IoUtil.toString((InputStream)data));
        artifactContent.setReferences(references);
        try {
            return (ArtifactMetaData)this.apicurioHttpClient.sendRequest(GroupRequestsProvider.updateArtifactWithReferences(this.normalizeGid(groupId), artifactId, headers, artifactContent));
        }
        catch (JsonProcessingException e) {
            throw RegistryClientImpl.parseSerializationError(e);
        }
    }

    @Override
    public void deleteArtifact(String groupId, String artifactId) {
        this.apicurioHttpClient.sendRequest(GroupRequestsProvider.deleteArtifact(this.normalizeGid(groupId), artifactId));
    }

    @Override
    public ArtifactMetaData getArtifactMetaData(String groupId, String artifactId) {
        return (ArtifactMetaData)this.apicurioHttpClient.sendRequest(GroupRequestsProvider.getArtifactMetaData(this.normalizeGid(groupId), artifactId));
    }

    @Override
    public ArtifactOwner getArtifactOwner(String groupId, String artifactId) {
        return (ArtifactOwner)this.apicurioHttpClient.sendRequest(GroupRequestsProvider.getArtifactOwner(this.normalizeGid(groupId), artifactId));
    }

    @Override
    public void updateArtifactMetaData(String groupId, String artifactId, EditableMetaData data) {
        try {
            this.apicurioHttpClient.sendRequest(GroupRequestsProvider.updateArtifactMetaData(this.normalizeGid(groupId), artifactId, data));
        }
        catch (JsonProcessingException e) {
            throw new RestClientException(new Error());
        }
    }

    @Override
    public void updateArtifactOwner(String groupId, String artifactId, ArtifactOwner owner) {
        try {
            this.apicurioHttpClient.sendRequest(GroupRequestsProvider.updateArtifactOwner(this.normalizeGid(groupId), artifactId, owner));
        }
        catch (JsonProcessingException e) {
            throw new RestClientException(new Error());
        }
    }

    @Override
    public VersionMetaData getArtifactVersionMetaDataByContent(String groupId, String artifactId, Boolean canonical, String contentType, InputStream data) {
        Map<String, List<String>> queryParams = canonical != null ? Map.of(Parameters.CANONICAL, Collections.singletonList(String.valueOf(canonical))) : Collections.emptyMap();
        Map<String, String> headers = contentType != null ? Map.of("Content-Type", contentType) : Collections.emptyMap();
        return (VersionMetaData)this.apicurioHttpClient.sendRequest(GroupRequestsProvider.getArtifactVersionMetaDataByContent(this.normalizeGid(groupId), artifactId, headers, queryParams, data));
    }

    @Override
    public VersionMetaData getArtifactVersionMetaDataByContent(String groupId, String artifactId, Boolean canonical, ArtifactContent artifactContent) {
        try {
            Map<String, List<String>> queryParams = canonical != null ? Map.of(Parameters.CANONICAL, Collections.singletonList(String.valueOf(canonical))) : Collections.emptyMap();
            Map<String, String> headers = Map.of("Content-Type", "application/get.extended+json");
            return (VersionMetaData)this.apicurioHttpClient.sendRequest(GroupRequestsProvider.getArtifactVersionMetaDataByContent(this.normalizeGid(groupId), artifactId, headers, queryParams, artifactContent));
        }
        catch (JsonProcessingException e) {
            throw RegistryClientImpl.parseSerializationError(e);
        }
    }

    @Override
    public List<RuleType> listArtifactRules(String groupId, String artifactId) {
        return (List)this.apicurioHttpClient.sendRequest(GroupRequestsProvider.listArtifactRules(this.normalizeGid(groupId), artifactId));
    }

    @Override
    public void createArtifactRule(String groupId, String artifactId, Rule data) {
        try {
            this.apicurioHttpClient.sendRequest(GroupRequestsProvider.createArtifactRule(this.normalizeGid(groupId), artifactId, data));
        }
        catch (JsonProcessingException e) {
            throw RegistryClientImpl.parseSerializationError(e);
        }
    }

    @Override
    public void deleteArtifactRules(String groupId, String artifactId) {
        this.apicurioHttpClient.sendRequest(GroupRequestsProvider.deleteArtifactRules(this.normalizeGid(groupId), artifactId));
    }

    @Override
    public Rule getArtifactRuleConfig(String groupId, String artifactId, RuleType rule) {
        return (Rule)this.apicurioHttpClient.sendRequest(GroupRequestsProvider.getArtifactRuleConfig(this.normalizeGid(groupId), artifactId, rule));
    }

    @Override
    public Rule updateArtifactRuleConfig(String groupId, String artifactId, RuleType rule, Rule data) {
        try {
            return (Rule)this.apicurioHttpClient.sendRequest(GroupRequestsProvider.updateArtifactRuleConfig(this.normalizeGid(groupId), artifactId, rule, data));
        }
        catch (JsonProcessingException e) {
            throw RegistryClientImpl.parseSerializationError(e);
        }
    }

    @Override
    public void deleteArtifactRule(String groupId, String artifactId, RuleType rule) {
        this.apicurioHttpClient.sendRequest(GroupRequestsProvider.deleteArtifactRule(this.normalizeGid(groupId), artifactId, rule));
    }

    @Override
    public void updateArtifactState(String groupId, String artifactId, UpdateState data) {
        try {
            this.apicurioHttpClient.sendRequest(GroupRequestsProvider.updateArtifactState(this.normalizeGid(groupId), artifactId, data));
        }
        catch (JsonProcessingException e) {
            throw RegistryClientImpl.parseSerializationError(e);
        }
    }

    @Override
    public void testUpdateArtifact(String groupId, String artifactId, String contentType, InputStream data) {
        Map<String, String> headers = contentType != null ? Map.of("Content-Type", contentType) : Collections.emptyMap();
        this.apicurioHttpClient.sendRequest(GroupRequestsProvider.testUpdateArtifact(this.normalizeGid(groupId), artifactId, headers, data));
    }

    @Override
    public InputStream getArtifactVersion(String groupId, String artifactId, String version) {
        return (InputStream)this.apicurioHttpClient.sendRequest(GroupRequestsProvider.getArtifactVersion(this.normalizeGid(groupId), artifactId, version));
    }

    @Override
    public VersionMetaData getArtifactVersionMetaData(String groupId, String artifactId, String version) {
        return (VersionMetaData)this.apicurioHttpClient.sendRequest(GroupRequestsProvider.getArtifactVersionMetaData(this.normalizeGid(groupId), artifactId, version));
    }

    @Override
    public void updateArtifactVersionMetaData(String groupId, String artifactId, String version, EditableMetaData data) {
        try {
            this.apicurioHttpClient.sendRequest(GroupRequestsProvider.updateArtifactVersionMetaData(this.normalizeGid(groupId), artifactId, version, data));
        }
        catch (JsonProcessingException e) {
            throw RegistryClientImpl.parseSerializationError(e);
        }
    }

    @Override
    public void deleteArtifactVersionMetaData(String groupId, String artifactId, String version) {
        this.apicurioHttpClient.sendRequest(GroupRequestsProvider.deleteArtifactVersionMetaData(this.normalizeGid(groupId), artifactId, version));
    }

    @Override
    public void updateArtifactVersionState(String groupId, String artifactId, String version, UpdateState data) {
        try {
            this.apicurioHttpClient.sendRequest(GroupRequestsProvider.updateArtifactVersionState(this.normalizeGid(groupId), artifactId, version, data));
        }
        catch (JsonProcessingException e) {
            throw RegistryClientImpl.parseSerializationError(e);
        }
    }

    @Override
    public VersionSearchResults listArtifactVersions(String groupId, String artifactId, Integer offset, Integer limit) {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        this.checkCommonQueryParams(null, null, limit, offset, queryParams);
        return (VersionSearchResults)this.apicurioHttpClient.sendRequest(GroupRequestsProvider.listArtifactVersions(this.normalizeGid(groupId), artifactId, queryParams));
    }

    @Override
    public VersionMetaData createArtifactVersion(String groupId, String artifactId, String version, String artifactName, String artifactDescription, String contentType, InputStream data) {
        Map<String, String> headers = this.headersFrom(version, artifactName, artifactDescription, contentType);
        return (VersionMetaData)this.apicurioHttpClient.sendRequest(GroupRequestsProvider.createArtifactVersion(this.normalizeGid(groupId), artifactId, data, headers));
    }

    @Override
    public ArtifactSearchResults listArtifactsInGroup(String groupId, SortBy orderBy, SortOrder order, Integer offset, Integer limit) {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        this.checkCommonQueryParams(orderBy, order, limit, offset, queryParams);
        return (ArtifactSearchResults)this.apicurioHttpClient.sendRequest(GroupRequestsProvider.listArtifactsInGroup(this.normalizeGid(groupId), queryParams));
    }

    protected CreateArtifact createArtifactLogic(String artifactId, String version, String artifactType, IfExists ifExists, Boolean canonical, String artifactName, String artifactDescription, String contentType, String artifactSHA) {
        if (artifactId != null && !ArtifactIdValidator.isArtifactIdAllowed((String)artifactId)) {
            throw new InvalidArtifactIdException();
        }
        Map<String, String> headers = this.headersFrom(version, artifactName, artifactDescription, contentType);
        if (artifactId != null) {
            headers.put("X-Registry-ArtifactId", artifactId);
        }
        if (artifactType != null) {
            headers.put("X-Registry-ArtifactType", artifactType);
        }
        if (artifactSHA != null) {
            headers.put("X-Registry-Hash-Algorithm", "SHA256");
            headers.put("X-Registry-Content-Hash", artifactSHA);
        }
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        if (canonical != null) {
            queryParams.put(Parameters.CANONICAL, Collections.singletonList(String.valueOf(canonical)));
        }
        if (ifExists != null) {
            queryParams.put(Parameters.IF_EXISTS, Collections.singletonList(ifExists.value()));
        }
        return new CreateArtifact(headers, queryParams);
    }

    @Override
    public ArtifactMetaData createArtifact(String groupId, String artifactId, String version, String artifactType, IfExists ifExists, Boolean canonical, String artifactName, String artifactDescription, String contentType, String fromURL, String artifactSHA, InputStream data) {
        CreateArtifact ca = this.createArtifactLogic(artifactId, version, artifactType, ifExists, canonical, artifactName, artifactDescription, contentType, artifactSHA);
        if (fromURL != null) {
            ca.headers.put("Content-Type", "application/create.extended+json");
            data = new StringBufferInputStream("{ \"content\" : \"" + fromURL + "\" }");
        }
        return (ArtifactMetaData)this.apicurioHttpClient.sendRequest(GroupRequestsProvider.createArtifact(this.normalizeGid(groupId), ca.headers, data, ca.queryParams));
    }

    @Override
    public ArtifactMetaData createArtifact(String groupId, String artifactId, String version, String artifactType, IfExists ifExists, Boolean canonical, String artifactName, String artifactDescription, String contentType, String fromURL, String artifactSHA, InputStream data, List<ArtifactReference> artifactReferences) {
        CreateArtifact ca = this.createArtifactLogic(artifactId, version, artifactType, ifExists, canonical, artifactName, artifactDescription, "application/create.extended+json", artifactSHA);
        Object content = IoUtil.toString((InputStream)data);
        if (fromURL != null) {
            content = " { \"content\" : \"" + fromURL + "\" }";
        }
        ArtifactContent artifactContent = new ArtifactContent();
        artifactContent.setContent((String)content);
        artifactContent.setReferences(artifactReferences);
        try {
            return (ArtifactMetaData)this.apicurioHttpClient.sendRequest(GroupRequestsProvider.createArtifactWithReferences(this.normalizeGid(groupId), ca.headers, artifactContent, ca.queryParams));
        }
        catch (JsonProcessingException e) {
            throw RegistryClientImpl.parseSerializationError(e);
        }
    }

    @Override
    public void deleteArtifactsInGroup(String groupId) {
        this.apicurioHttpClient.sendRequest(GroupRequestsProvider.deleteArtifactsInGroup(this.normalizeGid(groupId)));
    }

    @Override
    public void createArtifactGroup(GroupMetaData groupMetaData) {
        try {
            this.apicurioHttpClient.sendRequest(GroupRequestsProvider.createArtifactGroup(groupMetaData));
        }
        catch (JsonProcessingException e) {
            throw RegistryClientImpl.parseSerializationError(e);
        }
    }

    @Override
    public void deleteArtifactGroup(String groupId) {
        this.apicurioHttpClient.sendRequest(GroupRequestsProvider.deleteArtifactGroup(groupId));
    }

    @Override
    public GroupMetaData getArtifactGroup(String groupId) {
        return (GroupMetaData)this.apicurioHttpClient.sendRequest(GroupRequestsProvider.getArtifactGroup(groupId));
    }

    @Override
    public GroupSearchResults listGroups(SortBy orderBy, SortOrder order, Integer offset, Integer limit) {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        this.checkCommonQueryParams(orderBy, order, limit, offset, queryParams);
        return (GroupSearchResults)this.apicurioHttpClient.sendRequest(GroupRequestsProvider.listGroups(queryParams));
    }

    @Override
    public InputStream getContentById(long contentId) {
        return (InputStream)this.apicurioHttpClient.sendRequest(IdRequestsProvider.getContentById(contentId));
    }

    @Override
    public InputStream getContentByGlobalId(long globalId) {
        return this.getContentByGlobalId(globalId, false, false);
    }

    @Override
    public InputStream getContentByGlobalId(long globalId, Boolean canonical, Boolean dereference) {
        Map<String, List<String>> queryParams = dereference != null ? Map.of("dereference", Collections.singletonList(String.valueOf(dereference))) : Collections.emptyMap();
        return (InputStream)this.apicurioHttpClient.sendRequest(IdRequestsProvider.getContentByGlobalId(globalId, queryParams));
    }

    @Override
    public InputStream getContentByHash(String contentHash, Boolean canonical) {
        Map<String, List<String>> queryParams = canonical != null ? Map.of(Parameters.CANONICAL, Collections.singletonList(String.valueOf(canonical))) : Collections.emptyMap();
        return (InputStream)this.apicurioHttpClient.sendRequest(IdRequestsProvider.getContentByHash(contentHash, queryParams));
    }

    @Override
    public ArtifactSearchResults searchArtifacts(String group, String name, String description, List<String> labels, List<String> properties, Long globalId, Long contentId, SortBy orderBy, SortOrder order, Integer offset, Integer limit) {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        if (name != null) {
            queryParams.put(Parameters.NAME, Collections.singletonList(name));
        }
        if (description != null) {
            queryParams.put(Parameters.DESCRIPTION, Collections.singletonList(description));
        }
        if (group != null) {
            queryParams.put(Parameters.GROUP, Collections.singletonList(group));
        }
        this.checkCommonQueryParams(orderBy, order, limit, offset, queryParams);
        if (labels != null && !labels.isEmpty()) {
            queryParams.put(Parameters.LABELS, labels);
        }
        if (properties != null && !properties.isEmpty()) {
            queryParams.put(Parameters.PROPERTIES, properties);
        }
        if (globalId != null && globalId > 0L) {
            queryParams.put(Parameters.GLOBAL_ID, Collections.singletonList(Long.toString(globalId)));
        }
        if (contentId != null && contentId > 0L) {
            queryParams.put(Parameters.CONTENT_ID, Collections.singletonList(Long.toString(contentId)));
        }
        return (ArtifactSearchResults)this.apicurioHttpClient.sendRequest(SearchRequestsProvider.searchArtifacts(queryParams));
    }

    @Override
    public ArtifactSearchResults searchArtifactsByContent(InputStream data, SortBy orderBy, SortOrder order, Integer offset, Integer limit) {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        this.checkCommonQueryParams(orderBy, order, limit, offset, queryParams);
        return (ArtifactSearchResults)this.apicurioHttpClient.sendRequest(SearchRequestsProvider.searchArtifactsByContent(data, queryParams));
    }

    @Override
    @Deprecated
    public List<RuleType> listGlobalRules() {
        return (List)this.apicurioHttpClient.sendRequest(AdminRequestsProvider.listGlobalRules());
    }

    @Override
    @Deprecated
    public void createGlobalRule(Rule data) {
        try {
            this.apicurioHttpClient.sendRequest(AdminRequestsProvider.createGlobalRule(data));
        }
        catch (JsonProcessingException e) {
            throw RegistryClientImpl.parseSerializationError(e);
        }
    }

    @Override
    @Deprecated
    public void deleteAllGlobalRules() {
        this.apicurioHttpClient.sendRequest(AdminRequestsProvider.deleteAllGlobalRules());
    }

    @Override
    @Deprecated
    public Rule getGlobalRuleConfig(RuleType rule) {
        return (Rule)this.apicurioHttpClient.sendRequest(AdminRequestsProvider.getGlobalRule(rule));
    }

    @Override
    @Deprecated
    public Rule updateGlobalRuleConfig(RuleType rule, Rule data) {
        try {
            return (Rule)this.apicurioHttpClient.sendRequest(AdminRequestsProvider.updateGlobalRuleConfig(rule, data));
        }
        catch (JsonProcessingException e) {
            throw RegistryClientImpl.parseSerializationError(e);
        }
    }

    @Override
    @Deprecated
    public void deleteGlobalRule(RuleType rule) {
        this.apicurioHttpClient.sendRequest(AdminRequestsProvider.deleteGlobalRule(rule));
    }

    @Override
    @Deprecated
    public List<NamedLogConfiguration> listLogConfigurations() {
        return (List)this.apicurioHttpClient.sendRequest(AdminRequestsProvider.listLogConfigurations());
    }

    @Override
    @Deprecated
    public NamedLogConfiguration getLogConfiguration(String logger) {
        return (NamedLogConfiguration)this.apicurioHttpClient.sendRequest(AdminRequestsProvider.getLogConfiguration(logger));
    }

    @Override
    @Deprecated
    public NamedLogConfiguration setLogConfiguration(String logger, LogConfiguration data) {
        try {
            return (NamedLogConfiguration)this.apicurioHttpClient.sendRequest(AdminRequestsProvider.setLogConfiguration(logger, data));
        }
        catch (JsonProcessingException e) {
            throw RegistryClientImpl.parseSerializationError(e);
        }
    }

    @Override
    @Deprecated
    public NamedLogConfiguration removeLogConfiguration(String logger) {
        return (NamedLogConfiguration)this.apicurioHttpClient.sendRequest(AdminRequestsProvider.removeLogConfiguration(logger));
    }

    @Override
    @Deprecated
    public InputStream exportData() {
        return (InputStream)this.apicurioHttpClient.sendRequest(AdminRequestsProvider.exportData());
    }

    @Override
    @Deprecated
    public void importData(InputStream data) {
        this.importData(data, true, true);
    }

    @Override
    public void importData(InputStream data, boolean preserveGlobalIds, boolean preserveContentIds) {
        this.apicurioHttpClient.sendRequest(AdminRequestsProvider.importData(data, preserveGlobalIds, preserveContentIds));
    }

    @Override
    @Deprecated
    public void createRoleMapping(RoleMapping data) {
        try {
            this.apicurioHttpClient.sendRequest(AdminRequestsProvider.createRoleMapping(data));
        }
        catch (JsonProcessingException e) {
            throw RegistryClientImpl.parseSerializationError(e);
        }
    }

    @Override
    @Deprecated
    public void deleteRoleMapping(String principalId) {
        this.apicurioHttpClient.sendRequest(AdminRequestsProvider.deleteRoleMapping(principalId));
    }

    @Override
    @Deprecated
    public RoleMapping getRoleMapping(String principalId) {
        return (RoleMapping)this.apicurioHttpClient.sendRequest(AdminRequestsProvider.getRoleMapping(principalId));
    }

    @Override
    @Deprecated
    public List<RoleMapping> listRoleMappings() {
        return (List)this.apicurioHttpClient.sendRequest(AdminRequestsProvider.listRoleMappings());
    }

    @Override
    @Deprecated
    public void updateRoleMapping(String principalId, RoleType role) {
        try {
            this.apicurioHttpClient.sendRequest(AdminRequestsProvider.updateRoleMapping(principalId, role));
        }
        catch (JsonProcessingException e) {
            throw RegistryClientImpl.parseSerializationError(e);
        }
    }

    @Override
    public List<ConfigurationProperty> listConfigProperties() {
        return (List)this.apicurioHttpClient.sendRequest(AdminRequestsProvider.listConfigProperties());
    }

    @Override
    public ConfigurationProperty getConfigProperty(String propertyName) {
        return (ConfigurationProperty)this.apicurioHttpClient.sendRequest(AdminRequestsProvider.getConfigProperty(propertyName));
    }

    @Override
    public void setConfigProperty(String propertyName, String propertyValue) {
        try {
            this.apicurioHttpClient.sendRequest(AdminRequestsProvider.setConfigProperty(propertyName, propertyValue));
        }
        catch (JsonProcessingException e) {
            throw RegistryClientImpl.parseSerializationError(e);
        }
    }

    @Override
    public void deleteConfigProperty(String propertyName) {
        this.apicurioHttpClient.sendRequest(AdminRequestsProvider.deleteConfigProperty(propertyName));
    }

    @Override
    public UserInfo getCurrentUserInfo() {
        return (UserInfo)this.apicurioHttpClient.sendRequest(UsersRequestsProvider.getCurrentUserInfo());
    }

    @Override
    public List<ArtifactReference> getArtifactReferencesByGlobalId(long globalId) {
        return (List)this.apicurioHttpClient.sendRequest(IdRequestsProvider.getArtifactReferencesByGlobalId(globalId));
    }

    @Override
    public List<ArtifactReference> getArtifactReferencesByContentId(long contentId) {
        return (List)this.apicurioHttpClient.sendRequest(IdRequestsProvider.getArtifactReferencesByContentId(contentId));
    }

    @Override
    public List<ArtifactReference> getArtifactReferencesByContentHash(String contentHash) {
        return (List)this.apicurioHttpClient.sendRequest(IdRequestsProvider.getArtifactReferencesByContentHash(contentHash));
    }

    @Override
    public List<ArtifactReference> getArtifactReferencesByCoordinates(String groupId, String artifactId, String version) {
        return (List)this.apicurioHttpClient.sendRequest(GroupRequestsProvider.getArtifactReferencesByCoordinates(this.normalizeGid(groupId), artifactId, version));
    }

    @Override
    public void setNextRequestHeaders(Map<String, String> requestHeaders) {
        this.apicurioHttpClient.setNextRequestHeaders(requestHeaders);
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.apicurioHttpClient.getHeaders();
    }

    protected void checkCommonQueryParams(SortBy orderBy, SortOrder order, Integer limit, Integer offset, Map<String, List<String>> queryParams) {
        if (offset != null) {
            queryParams.put(Parameters.OFFSET, Collections.singletonList(String.valueOf(offset)));
        }
        if (limit != null) {
            queryParams.put(Parameters.LIMIT, Collections.singletonList(String.valueOf(limit)));
        }
        if (order != null) {
            queryParams.put(Parameters.SORT_ORDER, Collections.singletonList(order.value()));
        }
        if (orderBy != null) {
            queryParams.put(Parameters.ORDER_BY, Collections.singletonList(orderBy.value()));
        }
    }

    protected String normalizeGid(String groupId) {
        return groupId == null ? "default" : groupId;
    }

    private String encodeToBase64(String toEncode) {
        return Base64.getEncoder().encodeToString(toEncode.getBytes(StandardCharsets.UTF_8));
    }

    protected Map<String, String> headersFrom(String version, String artifactName, String artifactDescription, String contentType) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (version != null) {
            headers.put("X-Registry-Version", version);
        }
        if (artifactName != null) {
            headers.put("X-Registry-Name-Encoded", this.encodeToBase64(artifactName));
        }
        if (artifactDescription != null) {
            headers.put("X-Registry-Description-Encoded", this.encodeToBase64(artifactDescription));
        }
        if (contentType != null) {
            headers.put("Content-Type", contentType);
        }
        return headers;
    }

    protected static RestClientException parseSerializationError(JsonProcessingException ex) {
        Error error = new Error();
        error.setName(((Object)((Object)ex)).getClass().getSimpleName());
        error.setMessage(ex.getMessage());
        logger.debug("Error serializing request response", (Throwable)ex);
        return new RestClientException(error);
    }

    @Override
    public void close() {
        this.apicurioHttpClient.close();
    }

    protected static class CreateArtifact {
        public final Map<String, String> headers;
        public final Map<String, List<String>> queryParams;

        public CreateArtifact(Map<String, String> headers, Map<String, List<String>> queryParams) {
            this.headers = headers;
            this.queryParams = queryParams;
        }
    }
}

