/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest.client.request.provider;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.apicurio.registry.rest.v2.beans.ArtifactContent;
import io.apicurio.registry.rest.v2.beans.ArtifactMetaData;
import io.apicurio.registry.rest.v2.beans.ArtifactOwner;
import io.apicurio.registry.rest.v2.beans.ArtifactReference;
import io.apicurio.registry.rest.v2.beans.ArtifactSearchResults;
import io.apicurio.registry.rest.v2.beans.EditableMetaData;
import io.apicurio.registry.rest.v2.beans.GroupMetaData;
import io.apicurio.registry.rest.v2.beans.GroupSearchResults;
import io.apicurio.registry.rest.v2.beans.Rule;
import io.apicurio.registry.rest.v2.beans.UpdateState;
import io.apicurio.registry.rest.v2.beans.VersionMetaData;
import io.apicurio.registry.rest.v2.beans.VersionSearchResults;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.utils.IoUtil;
import io.apicurio.rest.client.request.Operation;
import io.apicurio.rest.client.request.Request;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

public class GroupRequestsProvider {
    private static final ObjectMapper mapper = new ObjectMapper();

    public static Request<Void> deleteArtifactsInGroup(String groupId) {
        return new Request.RequestBuilder().operation(Operation.DELETE).path("groups/%s/artifacts").pathParams(List.of(groupId)).responseType((TypeReference)new TypeReference<Void>(){}).build();
    }

    public static Request<ArtifactMetaData> createArtifact(String groupId, Map<String, String> headers, InputStream data, Map<String, List<String>> queryParams) {
        return new Request.RequestBuilder().operation(Operation.POST).path("groups/%s/artifacts").headers(headers).pathParams(List.of(groupId)).queryParams(queryParams).responseType((TypeReference)new TypeReference<ArtifactMetaData>(){}).data(data).build();
    }

    public static Request<ArtifactMetaData> createArtifactWithReferences(String groupId, Map<String, String> headers, ArtifactContent data, Map<String, List<String>> queryParams) throws JsonProcessingException {
        return new Request.RequestBuilder().operation(Operation.POST).path("groups/%s/artifacts").headers(headers).pathParams(List.of(groupId)).queryParams(queryParams).responseType((TypeReference)new TypeReference<ArtifactMetaData>(){}).data(IoUtil.toStream((byte[])mapper.writeValueAsBytes((Object)data))).build();
    }

    public static Request<ArtifactSearchResults> listArtifactsInGroup(String groupId, Map<String, List<String>> queryParams) {
        return new Request.RequestBuilder().operation(Operation.GET).path("groups/%s/artifacts").pathParams(List.of(groupId)).queryParams(queryParams).responseType((TypeReference)new TypeReference<ArtifactSearchResults>(){}).build();
    }

    public static Request<VersionMetaData> createArtifactVersion(String groupId, String artifactId, InputStream data, Map<String, String> headers) {
        return new Request.RequestBuilder().operation(Operation.POST).path("groups/%s/artifacts/%s/versions").headers(headers).pathParams(List.of(groupId, artifactId)).responseType((TypeReference)new TypeReference<VersionMetaData>(){}).data(data).build();
    }

    public static Request<VersionSearchResults> listArtifactVersions(String groupId, String artifactId, Map<String, List<String>> queryParams) {
        return new Request.RequestBuilder().operation(Operation.GET).path("groups/%s/artifacts/%s/versions").pathParams(List.of(groupId, artifactId)).queryParams(queryParams).responseType((TypeReference)new TypeReference<VersionSearchResults>(){}).build();
    }

    public static Request<Void> updateArtifactVersionState(String groupId, String artifactId, String version, UpdateState data) throws JsonProcessingException {
        return new Request.RequestBuilder().operation(Operation.PUT).path("groups/%s/artifacts/%s/versions/%s/state").pathParams(List.of(groupId, artifactId, version)).data(IoUtil.toStream((byte[])mapper.writeValueAsBytes((Object)data))).responseType((TypeReference)new TypeReference<Void>(){}).build();
    }

    public static Request<Void> deleteArtifactVersionMetaData(String groupId, String artifactId, String version) {
        return new Request.RequestBuilder().operation(Operation.DELETE).path("groups/%s/artifacts/%s/versions/%s/meta").pathParams(List.of(groupId, artifactId, version)).responseType((TypeReference)new TypeReference<Void>(){}).build();
    }

    public static Request<Void> updateArtifactVersionMetaData(String groupId, String artifactId, String version, EditableMetaData data) throws JsonProcessingException {
        return new Request.RequestBuilder().operation(Operation.PUT).path("groups/%s/artifacts/%s/versions/%s/meta").pathParams(List.of(groupId, artifactId, version)).data(IoUtil.toStream((byte[])mapper.writeValueAsBytes((Object)data))).responseType((TypeReference)new TypeReference<Void>(){}).build();
    }

    public static Request<VersionMetaData> getArtifactVersionMetaData(String groupId, String artifactId, String version) {
        return new Request.RequestBuilder().operation(Operation.GET).path("groups/%s/artifacts/%s/versions/%s/meta").pathParams(List.of(groupId, artifactId, version)).responseType((TypeReference)new TypeReference<VersionMetaData>(){}).build();
    }

    public static Request<InputStream> getArtifactVersion(String groupId, String artifactId, String version) {
        return new Request.RequestBuilder().operation(Operation.GET).path("groups/%s/artifacts/%s/versions/%s").pathParams(List.of(groupId, artifactId, version)).responseType((TypeReference)new TypeReference<InputStream>(){}).build();
    }

    public static Request<Void> testUpdateArtifact(String groupId, String artifactId, Map<String, String> headers, InputStream data) {
        return new Request.RequestBuilder().operation(Operation.PUT).path("groups/%s/artifacts/%s/test").headers(headers).pathParams(List.of(groupId, artifactId)).data(data).responseType((TypeReference)new TypeReference<Void>(){}).build();
    }

    public static Request<Void> testUpdateArtifact(String groupId, String artifactId, InputStream data) {
        return new Request.RequestBuilder().operation(Operation.PUT).path("groups/%s/artifacts/%s/test").pathParams(List.of(groupId, artifactId)).data(data).responseType((TypeReference)new TypeReference<Void>(){}).build();
    }

    public static Request<Void> updateArtifactState(String groupId, String artifactId, UpdateState data) throws JsonProcessingException {
        return new Request.RequestBuilder().operation(Operation.PUT).path("groups/%s/artifacts/%s/state").pathParams(List.of(groupId, artifactId)).data(IoUtil.toStream((byte[])mapper.writeValueAsBytes((Object)data))).responseType((TypeReference)new TypeReference<Void>(){}).build();
    }

    public static Request<Void> deleteArtifactRule(String groupId, String artifactId, RuleType rule) {
        return new Request.RequestBuilder().operation(Operation.DELETE).path("groups/%s/artifacts/%s/rules/%s").pathParams(List.of(groupId, artifactId, rule.value())).responseType((TypeReference)new TypeReference<Void>(){}).build();
    }

    public static Request<Rule> updateArtifactRuleConfig(String groupId, String artifactId, RuleType rule, Rule data) throws JsonProcessingException {
        return new Request.RequestBuilder().operation(Operation.PUT).responseType((TypeReference)new TypeReference<Rule>(){}).path("groups/%s/artifacts/%s/rules/%s").pathParams(List.of(groupId, artifactId, rule.value())).data(IoUtil.toStream((byte[])mapper.writeValueAsBytes((Object)data))).build();
    }

    public static Request<Rule> getArtifactRuleConfig(String groupId, String artifactId, RuleType rule) {
        return new Request.RequestBuilder().operation(Operation.GET).path("groups/%s/artifacts/%s/rules/%s").responseType((TypeReference)new TypeReference<Rule>(){}).pathParams(List.of(groupId, artifactId, rule.value())).build();
    }

    public static Request<Void> deleteArtifactRules(String groupId, String artifactId) {
        return new Request.RequestBuilder().operation(Operation.DELETE).path("groups/%s/artifacts/%s/rules").pathParams(List.of(groupId, artifactId)).responseType((TypeReference)new TypeReference<Void>(){}).build();
    }

    public static Request<Void> createArtifactRule(String groupId, String artifactId, Rule data) throws JsonProcessingException {
        return new Request.RequestBuilder().operation(Operation.POST).path("groups/%s/artifacts/%s/rules").pathParams(List.of(groupId, artifactId)).data(IoUtil.toStream((byte[])mapper.writeValueAsBytes((Object)data))).responseType((TypeReference)new TypeReference<Void>(){}).build();
    }

    public static Request<List<RuleType>> listArtifactRules(String groupId, String artifactId) {
        return new Request.RequestBuilder().operation(Operation.GET).path("groups/%s/artifacts/%s/rules").pathParams(List.of(groupId, artifactId)).responseType((TypeReference)new TypeReference<List<RuleType>>(){}).build();
    }

    public static Request<VersionMetaData> getArtifactVersionMetaDataByContent(String groupId, String artifactId, Map<String, String> headers, Map<String, List<String>> queryParams, InputStream data) {
        return new Request.RequestBuilder().operation(Operation.POST).path("groups/%s/artifacts/%s/meta").headers(headers).pathParams(List.of(groupId, artifactId)).queryParams(queryParams).responseType((TypeReference)new TypeReference<VersionMetaData>(){}).data(data).build();
    }

    public static Request<VersionMetaData> getArtifactVersionMetaDataByContent(String groupId, String artifactId, Map<String, String> headers, Map<String, List<String>> queryParams, ArtifactContent artifactContent) throws JsonProcessingException {
        return new Request.RequestBuilder().operation(Operation.POST).path("groups/%s/artifacts/%s/meta").headers(headers).pathParams(List.of(groupId, artifactId)).queryParams(queryParams).responseType((TypeReference)new TypeReference<VersionMetaData>(){}).data(IoUtil.toStream((byte[])mapper.writeValueAsBytes((Object)artifactContent))).build();
    }

    public static Request<VersionMetaData> getArtifactVersionMetaDataByContent(String groupId, String artifactId, Map<String, List<String>> queryParams, InputStream data) {
        return new Request.RequestBuilder().operation(Operation.POST).path("groups/%s/artifacts/%s/meta").pathParams(List.of(groupId, artifactId)).queryParams(queryParams).responseType((TypeReference)new TypeReference<VersionMetaData>(){}).data(data).build();
    }

    public static Request<Void> updateArtifactMetaData(String groupId, String artifactId, EditableMetaData data) throws JsonProcessingException {
        return new Request.RequestBuilder().operation(Operation.PUT).path("groups/%s/artifacts/%s/meta").pathParams(List.of(groupId, artifactId)).data(IoUtil.toStream((byte[])mapper.writeValueAsBytes((Object)data))).responseType((TypeReference)new TypeReference<Void>(){}).build();
    }

    public static Request<Void> updateArtifactOwner(String groupId, String artifactId, ArtifactOwner owner) throws JsonProcessingException {
        return new Request.RequestBuilder().operation(Operation.PUT).path("groups/%s/artifacts/%s/owner").pathParams(List.of(groupId, artifactId)).data(IoUtil.toStream((byte[])mapper.writeValueAsBytes((Object)owner))).responseType((TypeReference)new TypeReference<Void>(){}).build();
    }

    public static Request<ArtifactMetaData> getArtifactMetaData(String groupId, String artifactId) {
        return new Request.RequestBuilder().operation(Operation.GET).path("groups/%s/artifacts/%s/meta").pathParams(List.of(groupId, artifactId)).responseType((TypeReference)new TypeReference<ArtifactMetaData>(){}).build();
    }

    public static Request<ArtifactOwner> getArtifactOwner(String groupId, String artifactId) {
        return new Request.RequestBuilder().operation(Operation.GET).path("groups/%s/artifacts/%s/owner").pathParams(List.of(groupId, artifactId)).responseType((TypeReference)new TypeReference<ArtifactOwner>(){}).build();
    }

    public static Request<Void> deleteArtifact(String groupId, String artifactId) {
        return new Request.RequestBuilder().operation(Operation.DELETE).path("groups/%s/artifacts/%s").pathParams(List.of(groupId, artifactId)).responseType((TypeReference)new TypeReference<Void>(){}).build();
    }

    public static Request<ArtifactMetaData> updateArtifact(String groupId, String artifactId, Map<String, String> headers, InputStream data) {
        return new Request.RequestBuilder().operation(Operation.PUT).path("groups/%s/artifacts/%s").headers(headers).pathParams(List.of(groupId, artifactId)).responseType((TypeReference)new TypeReference<ArtifactMetaData>(){}).data(data).build();
    }

    public static Request<ArtifactMetaData> updateArtifactWithReferences(String groupId, String artifactId, Map<String, String> headers, ArtifactContent data) throws JsonProcessingException {
        return new Request.RequestBuilder().operation(Operation.PUT).path("groups/%s/artifacts/%s").headers(headers).pathParams(List.of(groupId, artifactId)).responseType((TypeReference)new TypeReference<ArtifactMetaData>(){}).data(IoUtil.toStream((byte[])mapper.writeValueAsBytes((Object)data))).build();
    }

    public static Request<InputStream> getLatestArtifact(String groupId, String artifactId) {
        return new Request.RequestBuilder().operation(Operation.GET).path("groups/%s/artifacts/%s").pathParams(List.of(groupId, artifactId)).responseType((TypeReference)new TypeReference<InputStream>(){}).build();
    }

    public static Request<List<ArtifactReference>> getArtifactReferencesByCoordinates(String groupId, String artifactId, String version) {
        return new Request.RequestBuilder().operation(Operation.GET).path("groups/%s/artifacts/%s/versions/%s/references").pathParams(List.of(groupId == null ? "null" : groupId, artifactId, version)).responseType((TypeReference)new TypeReference<List<ArtifactReference>>(){}).build();
    }

    public static Request<Void> createArtifactGroup(GroupMetaData groupMetaData) throws JsonProcessingException {
        return new Request.RequestBuilder().operation(Operation.POST).path("groups").data(IoUtil.toStream((byte[])mapper.writeValueAsBytes((Object)groupMetaData))).responseType((TypeReference)new TypeReference<Void>(){}).build();
    }

    public static Request<Void> deleteArtifactGroup(String groupId) {
        return new Request.RequestBuilder().operation(Operation.DELETE).path("groups/%s").pathParams(List.of(groupId)).responseType((TypeReference)new TypeReference<Void>(){}).build();
    }

    public static Request<GroupMetaData> getArtifactGroup(String groupId) {
        return new Request.RequestBuilder().operation(Operation.GET).path("groups/%s").pathParams(List.of(groupId)).responseType((TypeReference)new TypeReference<GroupMetaData>(){}).build();
    }

    public static Request<GroupSearchResults> listGroups(Map<String, List<String>> queryParams) {
        return new Request.RequestBuilder().operation(Operation.GET).path("groups").queryParams(queryParams).responseType((TypeReference)new TypeReference<GroupSearchResults>(){}).build();
    }
}

