/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.apicurio.common.apps.config.Info;
import io.quarkus.jackson.ObjectMapperCustomizer;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Singleton;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class JacksonDateTimeCustomizer
implements ObjectMapperCustomizer {
    private static Logger log = LoggerFactory.getLogger(JacksonDateTimeCustomizer.class);
    private static final String DEFAULT_DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    private static final String DEFAULT_DATE_TIME_FORMAT_TZ = "UTC";
    @ConfigProperty(name="registry.apis.v2.date-format", defaultValue="yyyy-MM-dd'T'HH:mm:ssZ")
    @Info(category="api", description="API date format", availableSince="2.4.3.Final")
    String dateFormat;
    @ConfigProperty(name="registry.apis.v2.date-format-timezone", defaultValue="UTC")
    @Info(category="api", description="API date format (TZ)", availableSince="2.4.3.Final")
    String timezone;

    @PostConstruct
    protected void postConstruct() {
        if (this.dateFormat.equals(DEFAULT_DATE_TIME_FORMAT)) {
            log.info("---------------------------------------------------------------------");
            log.info("Legacy REST API date formats enabled (this is currently the default).");
            log.info("");
            log.info("For maximum compatibility and to ease upgrades from older versions");
            log.info("of Registry, the date format used in the REST API is not compliant");
            log.info("with OpenAPI standards (due to a bug in older versions).  Please");
            log.info("make sure you upgrade all of your client applications to use the");
            log.info("latest client version.  The next release will fix the date format");
            log.info("bug, which will result in older clients no longer being compatible");
            log.info("with the REST API.");
            log.info("");
            log.info("If you would like to fix the date format bug in THIS version of");
            log.info("Registry (great!) please set the following ENV variable + value:");
            log.info("");
            log.info("REGISTRY_APIS_V2_DATE_FORMAT=yyyy-MM-dd'T'HH:mm:ss'Z'");
            log.info("");
            log.info("Doing this will result in a REST API that is OpenAPI compliant, but");
            log.info("please remember to upgrade all your client applications first!");
            log.info("---------------------------------------------------------------------");
        } else {
            log.info("---------------------------------------------------------------------");
            log.info("Overriding REST API date format.  Using: " + this.dateFormat);
            log.info("---------------------------------------------------------------------");
        }
    }

    public void customize(ObjectMapper mapper) {
        try {
            JacksonDateTimeCustomizer.configureDateFormat(mapper, this.dateFormat, this.timezone);
        }
        catch (Exception e) {
            log.error("Error setting REST API date format.", (Throwable)e);
            JacksonDateTimeCustomizer.configureDateFormat(mapper, DEFAULT_DATE_TIME_FORMAT, DEFAULT_DATE_TIME_FORMAT_TZ);
        }
    }

    protected static void configureDateFormat(ObjectMapper mapper, String format, String tz) {
        SimpleDateFormat df = new SimpleDateFormat(format);
        df.setTimeZone(TimeZone.getTimeZone(tz));
        mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        mapper.setDateFormat((DateFormat)df);
    }
}

