
package io.apicurio.registry.rest.v3.beans;

import java.util.HashMap;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

@io.quarkus.runtime.annotations.RegisterForReflection
public enum IfArtifactExists {

    FAIL("FAIL"),
    CREATE_VERSION("CREATE_VERSION"),
    FIND_OR_CREATE_VERSION("FIND_OR_CREATE_VERSION");
    private final String value;
    private final static Map<String, IfArtifactExists> CONSTANTS = new HashMap<String, IfArtifactExists>();

    static {
        for (IfArtifactExists c: values()) {
            CONSTANTS.put(c.value, c);
        }
    }

    private IfArtifactExists(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static IfArtifactExists fromValue(String value) {
        IfArtifactExists constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        } else {
            return constant;
        }
    }

}
