/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.model;

import jakarta.validation.ValidationException;
import java.util.regex.Pattern;

public final class ArtifactId {
    private static final Pattern VALID_PATTERN = Pattern.compile(".{1,512}");
    private final String rawArtifactId;

    public ArtifactId(String rawArtifactId) {
        if (!ArtifactId.isValid(rawArtifactId)) {
            throw new ValidationException("Artifact ID '" + rawArtifactId + "' is invalid. It must have length 1..512 (inclusive).");
        }
        this.rawArtifactId = rawArtifactId;
    }

    public String toString() {
        return this.rawArtifactId;
    }

    public static boolean isValid(String rawArtifactId) {
        return rawArtifactId != null && VALID_PATTERN.matcher(rawArtifactId).matches();
    }

    public String getRawArtifactId() {
        return this.rawArtifactId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArtifactId)) {
            return false;
        }
        ArtifactId other = (ArtifactId)o;
        String this$rawArtifactId = this.getRawArtifactId();
        String other$rawArtifactId = other.getRawArtifactId();
        return !(this$rawArtifactId == null ? other$rawArtifactId != null : !this$rawArtifactId.equals(other$rawArtifactId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $rawArtifactId = this.getRawArtifactId();
        result = result * 59 + ($rawArtifactId == null ? 43 : $rawArtifactId.hashCode());
        return result;
    }
}

