/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.model;

import jakarta.validation.ValidationException;
import java.util.regex.Pattern;

public final class BranchId {
    private static final Pattern VALID_PATTERN = Pattern.compile("[a-zA-Z0-9._\\-+]{1,256}");
    public static final BranchId LATEST = new BranchId("latest");
    private final String rawBranchId;

    public BranchId(String rawBranchId) {
        if (!BranchId.isValid(rawBranchId)) {
            throw new ValidationException("Branch ID '" + rawBranchId + "' is invalid. It must consist of alphanumeric characters or '._-+', and have length 1..256 (inclusive).");
        }
        this.rawBranchId = rawBranchId;
    }

    public String toString() {
        return this.rawBranchId;
    }

    public static boolean isValid(String rawBranchId) {
        return rawBranchId != null && VALID_PATTERN.matcher(rawBranchId).matches();
    }

    public String getRawBranchId() {
        return this.rawBranchId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BranchId)) {
            return false;
        }
        BranchId other = (BranchId)o;
        String this$rawBranchId = this.getRawBranchId();
        String other$rawBranchId = other.getRawBranchId();
        return !(this$rawBranchId == null ? other$rawBranchId != null : !this$rawBranchId.equals(other$rawBranchId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $rawBranchId = this.getRawBranchId();
        result = result * 59 + ($rawBranchId == null ? 43 : $rawBranchId.hashCode());
        return result;
    }
}

