/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest.v3;

import io.apicurio.registry.rest.v3.beans.ArtifactTypeInfo;
import io.apicurio.registry.rest.v3.beans.ConfigurationProperty;
import io.apicurio.registry.rest.v3.beans.CreateRule;
import io.apicurio.registry.rest.v3.beans.RoleMapping;
import io.apicurio.registry.rest.v3.beans.RoleMappingSearchResults;
import io.apicurio.registry.rest.v3.beans.Rule;
import io.apicurio.registry.rest.v3.beans.SnapshotMetaData;
import io.apicurio.registry.rest.v3.beans.UpdateConfigurationProperty;
import io.apicurio.registry.rest.v3.beans.UpdateRole;
import io.apicurio.registry.types.RuleType;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.List;

@Path(value="/apis/registry/v3/admin")
public interface AdminResource {
    @Path(value="/rules")
    @GET
    @Produces(value={"application/json"})
    public List<RuleType> listGlobalRules();

    @Path(value="/rules")
    @POST
    @Consumes(value={"application/json"})
    public void createGlobalRule(@NotNull CreateRule var1);

    @Path(value="/rules")
    @DELETE
    public void deleteAllGlobalRules();

    @Path(value="/rules/{ruleType}")
    @GET
    @Produces(value={"application/json"})
    public Rule getGlobalRuleConfig(@PathParam(value="ruleType") RuleType var1);

    @Path(value="/rules/{ruleType}")
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Rule updateGlobalRuleConfig(@PathParam(value="ruleType") RuleType var1, @NotNull Rule var2);

    @Path(value="/rules/{ruleType}")
    @DELETE
    public void deleteGlobalRule(@PathParam(value="ruleType") RuleType var1);

    @Path(value="/export")
    @GET
    @Produces(value={"application/json", "application/zip"})
    public Response exportData(@QueryParam(value="forBrowser") Boolean var1);

    @Path(value="/import")
    @POST
    @Consumes(value={"application/zip"})
    public void importData(@HeaderParam(value="X-Registry-Preserve-GlobalId") Boolean var1, @HeaderParam(value="X-Registry-Preserve-ContentId") Boolean var2, @NotNull InputStream var3);

    @Path(value="/roleMappings/{principalId}")
    @GET
    @Produces(value={"application/json"})
    public RoleMapping getRoleMapping(@PathParam(value="principalId") String var1);

    @Path(value="/roleMappings/{principalId}")
    @PUT
    @Consumes(value={"application/json"})
    public void updateRoleMapping(@PathParam(value="principalId") String var1, @NotNull UpdateRole var2);

    @Path(value="/roleMappings/{principalId}")
    @DELETE
    public void deleteRoleMapping(@PathParam(value="principalId") String var1);

    @Path(value="/config/properties")
    @GET
    @Produces(value={"application/json"})
    public List<ConfigurationProperty> listConfigProperties();

    @Path(value="/config/properties/{propertyName}")
    @GET
    @Produces(value={"application/json"})
    public ConfigurationProperty getConfigProperty(@PathParam(value="propertyName") String var1);

    @Path(value="/config/properties/{propertyName}")
    @PUT
    @Consumes(value={"application/json"})
    public void updateConfigProperty(@PathParam(value="propertyName") String var1, @NotNull UpdateConfigurationProperty var2);

    @Path(value="/config/properties/{propertyName}")
    @DELETE
    public void resetConfigProperty(@PathParam(value="propertyName") String var1);

    @Path(value="/roleMappings")
    @GET
    @Produces(value={"application/json"})
    public RoleMappingSearchResults listRoleMappings(@QueryParam(value="limit") BigInteger var1, @QueryParam(value="offset") BigInteger var2);

    @Path(value="/roleMappings")
    @POST
    @Consumes(value={"application/json"})
    public void createRoleMapping(@NotNull RoleMapping var1);

    @Path(value="/config/artifactTypes")
    @GET
    @Produces(value={"application/json"})
    public List<ArtifactTypeInfo> listArtifactTypes();

    @Path(value="/snapshots")
    @POST
    @Produces(value={"application/json"})
    public SnapshotMetaData triggerSnapshot();
}

