/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest.v3;

import io.apicurio.registry.rest.v3.beans.AddVersionToBranch;
import io.apicurio.registry.rest.v3.beans.ArtifactMetaData;
import io.apicurio.registry.rest.v3.beans.ArtifactReference;
import io.apicurio.registry.rest.v3.beans.ArtifactSearchResults;
import io.apicurio.registry.rest.v3.beans.ArtifactSortBy;
import io.apicurio.registry.rest.v3.beans.BranchMetaData;
import io.apicurio.registry.rest.v3.beans.BranchSearchResults;
import io.apicurio.registry.rest.v3.beans.Comment;
import io.apicurio.registry.rest.v3.beans.CreateArtifact;
import io.apicurio.registry.rest.v3.beans.CreateArtifactResponse;
import io.apicurio.registry.rest.v3.beans.CreateBranch;
import io.apicurio.registry.rest.v3.beans.CreateGroup;
import io.apicurio.registry.rest.v3.beans.CreateRule;
import io.apicurio.registry.rest.v3.beans.CreateVersion;
import io.apicurio.registry.rest.v3.beans.EditableArtifactMetaData;
import io.apicurio.registry.rest.v3.beans.EditableBranchMetaData;
import io.apicurio.registry.rest.v3.beans.EditableGroupMetaData;
import io.apicurio.registry.rest.v3.beans.EditableVersionMetaData;
import io.apicurio.registry.rest.v3.beans.GroupMetaData;
import io.apicurio.registry.rest.v3.beans.GroupSearchResults;
import io.apicurio.registry.rest.v3.beans.GroupSortBy;
import io.apicurio.registry.rest.v3.beans.HandleReferencesType;
import io.apicurio.registry.rest.v3.beans.IfArtifactExists;
import io.apicurio.registry.rest.v3.beans.NewComment;
import io.apicurio.registry.rest.v3.beans.ReplaceBranchVersions;
import io.apicurio.registry.rest.v3.beans.Rule;
import io.apicurio.registry.rest.v3.beans.SortOrder;
import io.apicurio.registry.rest.v3.beans.VersionMetaData;
import io.apicurio.registry.rest.v3.beans.VersionSearchResults;
import io.apicurio.registry.rest.v3.beans.VersionSortBy;
import io.apicurio.registry.types.ReferenceType;
import io.apicurio.registry.types.RuleType;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.math.BigInteger;
import java.util.List;

@Path(value="/apis/registry/v3/groups")
public interface GroupsResource {
    @Path(value="/{groupId}/artifacts/{artifactId}/versions/{versionExpression}")
    @GET
    @Produces(value={"application/json"})
    public VersionMetaData getArtifactVersionMetaData(@PathParam(value="groupId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var1, @PathParam(value="artifactId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var2, @PathParam(value="versionExpression") String var3);

    @Path(value="/{groupId}/artifacts/{artifactId}/versions/{versionExpression}")
    @PUT
    @Consumes(value={"application/json"})
    public void updateArtifactVersionMetaData(@PathParam(value="groupId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var1, @PathParam(value="artifactId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var2, @PathParam(value="versionExpression") String var3, @NotNull EditableVersionMetaData var4);

    @Path(value="/{groupId}/artifacts/{artifactId}/versions/{versionExpression}")
    @DELETE
    public void deleteArtifactVersion(@PathParam(value="groupId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var1, @PathParam(value="artifactId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var2, @PathParam(value="versionExpression") String var3);

    @Path(value="/{groupId}/artifacts/{artifactId}/rules")
    @GET
    @Produces(value={"application/json"})
    public List<RuleType> listArtifactRules(@PathParam(value="groupId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var1, @PathParam(value="artifactId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var2);

    @Path(value="/{groupId}/artifacts/{artifactId}/rules")
    @POST
    @Consumes(value={"application/json"})
    public void createArtifactRule(@PathParam(value="groupId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var1, @PathParam(value="artifactId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var2, @NotNull CreateRule var3);

    @Path(value="/{groupId}/artifacts/{artifactId}/rules")
    @DELETE
    public void deleteArtifactRules(@PathParam(value="groupId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var1, @PathParam(value="artifactId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var2);

    @Path(value="/{groupId}/artifacts/{artifactId}/rules/{ruleType}")
    @GET
    @Produces(value={"application/json"})
    public Rule getArtifactRuleConfig(@PathParam(value="groupId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var1, @PathParam(value="artifactId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var2, @PathParam(value="ruleType") RuleType var3);

    @Path(value="/{groupId}/artifacts/{artifactId}/rules/{ruleType}")
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Rule updateArtifactRuleConfig(@PathParam(value="groupId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var1, @PathParam(value="artifactId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var2, @PathParam(value="ruleType") RuleType var3, @NotNull Rule var4);

    @Path(value="/{groupId}/artifacts/{artifactId}/rules/{ruleType}")
    @DELETE
    public void deleteArtifactRule(@PathParam(value="groupId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var1, @PathParam(value="artifactId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var2, @PathParam(value="ruleType") RuleType var3);

    @Path(value="/{groupId}/artifacts/{artifactId}/versions/{versionExpression}/references")
    @GET
    @Produces(value={"application/json"})
    public List<ArtifactReference> getArtifactVersionReferences(@PathParam(value="groupId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var1, @PathParam(value="artifactId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var2, @PathParam(value="versionExpression") String var3, @QueryParam(value="refType") ReferenceType var4);

    @Path(value="/{groupId}/artifacts")
    @GET
    @Produces(value={"application/json"})
    public ArtifactSearchResults listArtifactsInGroup(@PathParam(value="groupId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var1, @QueryParam(value="limit") BigInteger var2, @QueryParam(value="offset") BigInteger var3, @QueryParam(value="order") SortOrder var4, @QueryParam(value="orderby") ArtifactSortBy var5);

    @Path(value="/{groupId}/artifacts")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public CreateArtifactResponse createArtifact(@PathParam(value="groupId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var1, @QueryParam(value="ifExists") IfArtifactExists var2, @QueryParam(value="canonical") Boolean var3, @QueryParam(value="dryRun") Boolean var4, @NotNull CreateArtifact var5);

    @Path(value="/{groupId}/artifacts")
    @DELETE
    public void deleteArtifactsInGroup(@PathParam(value="groupId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var1);

    @GET
    @Produces(value={"application/json"})
    public GroupSearchResults listGroups(@QueryParam(value="limit") BigInteger var1, @QueryParam(value="offset") BigInteger var2, @QueryParam(value="order") SortOrder var3, @QueryParam(value="orderby") GroupSortBy var4);

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public GroupMetaData createGroup(@NotNull CreateGroup var1);

    @Path(value="/{groupId}/artifacts/{artifactId}/versions/{versionExpression}/comments")
    @GET
    @Produces(value={"application/json"})
    public List<Comment> getArtifactVersionComments(@PathParam(value="groupId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var1, @PathParam(value="artifactId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var2, @PathParam(value="versionExpression") String var3);

    @Path(value="/{groupId}/artifacts/{artifactId}/versions/{versionExpression}/comments")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Comment addArtifactVersionComment(@PathParam(value="groupId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var1, @PathParam(value="artifactId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var2, @PathParam(value="versionExpression") String var3, @NotNull NewComment var4);

    @Path(value="/{groupId}/artifacts/{artifactId}/versions/{versionExpression}/comments/{commentId}")
    @PUT
    @Consumes(value={"application/json"})
    public void updateArtifactVersionComment(@PathParam(value="groupId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var1, @PathParam(value="artifactId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var2, @PathParam(value="versionExpression") String var3, @PathParam(value="commentId") String var4, @NotNull NewComment var5);

    @Path(value="/{groupId}/artifacts/{artifactId}/versions/{versionExpression}/comments/{commentId}")
    @DELETE
    public void deleteArtifactVersionComment(@PathParam(value="groupId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var1, @PathParam(value="artifactId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var2, @PathParam(value="versionExpression") String var3, @PathParam(value="commentId") String var4);

    @Path(value="/{groupId}/artifacts/{artifactId}/branches")
    @GET
    @Produces(value={"application/json"})
    public BranchSearchResults listBranches(@PathParam(value="groupId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var1, @PathParam(value="artifactId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var2, @QueryParam(value="offset") BigInteger var3, @QueryParam(value="limit") BigInteger var4);

    @Path(value="/{groupId}/artifacts/{artifactId}/branches")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public BranchMetaData createBranch(@PathParam(value="groupId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var1, @PathParam(value="artifactId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var2, @NotNull CreateBranch var3);

    @Path(value="/{groupId}/artifacts/{artifactId}/versions")
    @GET
    @Produces(value={"application/json"})
    public VersionSearchResults listArtifactVersions(@PathParam(value="groupId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var1, @PathParam(value="artifactId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var2, @QueryParam(value="offset") BigInteger var3, @QueryParam(value="limit") BigInteger var4, @QueryParam(value="order") SortOrder var5, @QueryParam(value="orderby") VersionSortBy var6);

    @Path(value="/{groupId}/artifacts/{artifactId}/versions")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public VersionMetaData createArtifactVersion(@PathParam(value="groupId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var1, @PathParam(value="artifactId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var2, @QueryParam(value="dryRun") Boolean var3, @NotNull CreateVersion var4);

    @Path(value="/{groupId}/artifacts/{artifactId}/branches/{branchId}")
    @GET
    @Produces(value={"application/json"})
    public BranchMetaData getBranchMetaData(@PathParam(value="groupId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var1, @PathParam(value="artifactId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var2, @PathParam(value="branchId") @Pattern(regexp="^[a-zA-Z0-9._\\-+]{1,256}$") @Pattern(regexp="^[a-zA-Z0-9._\\-+]{1,256}$") String var3);

    @Path(value="/{groupId}/artifacts/{artifactId}/branches/{branchId}")
    @PUT
    @Consumes(value={"application/json"})
    public void updateBranchMetaData(@PathParam(value="groupId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var1, @PathParam(value="artifactId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var2, @PathParam(value="branchId") @Pattern(regexp="^[a-zA-Z0-9._\\-+]{1,256}$") @Pattern(regexp="^[a-zA-Z0-9._\\-+]{1,256}$") String var3, @NotNull EditableBranchMetaData var4);

    @Path(value="/{groupId}/artifacts/{artifactId}/branches/{branchId}")
    @DELETE
    public void deleteBranch(@PathParam(value="groupId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var1, @PathParam(value="artifactId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var2, @PathParam(value="branchId") @Pattern(regexp="^[a-zA-Z0-9._\\-+]{1,256}$") @Pattern(regexp="^[a-zA-Z0-9._\\-+]{1,256}$") String var3);

    @Path(value="/{groupId}")
    @GET
    @Produces(value={"application/json"})
    public GroupMetaData getGroupById(@PathParam(value="groupId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var1);

    @Path(value="/{groupId}")
    @PUT
    @Consumes(value={"application/json"})
    public void updateGroupById(@PathParam(value="groupId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var1, @NotNull EditableGroupMetaData var2);

    @Path(value="/{groupId}")
    @DELETE
    public void deleteGroupById(@PathParam(value="groupId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var1);

    @Path(value="/{groupId}/artifacts/{artifactId}")
    @GET
    @Produces(value={"application/json"})
    public ArtifactMetaData getArtifactMetaData(@PathParam(value="groupId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var1, @PathParam(value="artifactId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var2);

    @Path(value="/{groupId}/artifacts/{artifactId}")
    @PUT
    @Consumes(value={"application/json"})
    public void updateArtifactMetaData(@PathParam(value="groupId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var1, @PathParam(value="artifactId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var2, @NotNull EditableArtifactMetaData var3);

    @Path(value="/{groupId}/artifacts/{artifactId}")
    @DELETE
    public void deleteArtifact(@PathParam(value="groupId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var1, @PathParam(value="artifactId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var2);

    @Path(value="/{groupId}/artifacts/{artifactId}/versions/{versionExpression}/content")
    @GET
    @Produces(value={"*/*"})
    public Response getArtifactVersionContent(@PathParam(value="groupId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var1, @PathParam(value="artifactId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var2, @PathParam(value="versionExpression") String var3, @QueryParam(value="references") HandleReferencesType var4);

    @Path(value="/{groupId}/artifacts/{artifactId}/branches/{branchId}/versions")
    @GET
    @Produces(value={"application/json"})
    public VersionSearchResults listBranchVersions(@PathParam(value="groupId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var1, @PathParam(value="artifactId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var2, @PathParam(value="branchId") @Pattern(regexp="^[a-zA-Z0-9._\\-+]{1,256}$") @Pattern(regexp="^[a-zA-Z0-9._\\-+]{1,256}$") String var3, @QueryParam(value="offset") BigInteger var4, @QueryParam(value="limit") BigInteger var5);

    @Path(value="/{groupId}/artifacts/{artifactId}/branches/{branchId}/versions")
    @PUT
    @Consumes(value={"application/json"})
    public void replaceBranchVersions(@PathParam(value="groupId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var1, @PathParam(value="artifactId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var2, @PathParam(value="branchId") @Pattern(regexp="^[a-zA-Z0-9._\\-+]{1,256}$") @Pattern(regexp="^[a-zA-Z0-9._\\-+]{1,256}$") String var3, @NotNull ReplaceBranchVersions var4);

    @Path(value="/{groupId}/artifacts/{artifactId}/branches/{branchId}/versions")
    @POST
    @Consumes(value={"application/json"})
    public void addVersionToBranch(@PathParam(value="groupId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var1, @PathParam(value="artifactId") @Pattern(regexp="^.{1,512}$") @Pattern(regexp="^.{1,512}$") String var2, @PathParam(value="branchId") @Pattern(regexp="^[a-zA-Z0-9._\\-+]{1,256}$") @Pattern(regexp="^[a-zA-Z0-9._\\-+]{1,256}$") String var3, @NotNull AddVersionToBranch var4);
}

