
package io.apicurio.registry.rest.v3.beans;

import java.util.HashMap;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

@io.quarkus.runtime.annotations.RegisterForReflection
public enum VersionSortBy {

    groupId("groupId"),
    artifactId("artifactId"),
    version("version"),
    name("name"),
    createdOn("createdOn"),
    modifiedOn("modifiedOn"),
    globalId("globalId");
    private final String value;
    private final static Map<String, VersionSortBy> CONSTANTS = new HashMap<String, VersionSortBy>();

    static {
        for (VersionSortBy c: values()) {
            CONSTANTS.put(c.value, c);
        }
    }

    private VersionSortBy(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static VersionSortBy fromValue(String value) {
        VersionSortBy constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        } else {
            return constant;
        }
    }

}
