/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.utils;

import io.apicurio.registry.utils.RegistryProperties;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesUtil {
    private static final Logger log = LoggerFactory.getLogger(PropertiesUtil.class);
    private static final boolean debug = Boolean.getBoolean("apicurio.debug");

    /*
     * WARNING - void declaration
     */
    public static Properties properties(InjectionPoint ip) {
        RegistryProperties cp = (RegistryProperties)ip.getAnnotated().getAnnotation(RegistryProperties.class);
        if (cp == null) {
            throw new IllegalArgumentException(ip.getMember() + " is not annotated with @RegistryProperties");
        }
        Object[] prefixes = (String[])Stream.of(cp.value()).map(pfx -> pfx.isEmpty() || pfx.endsWith(".") ? pfx : pfx + ".").distinct().toArray(String[]::new);
        if (prefixes.length == 0) {
            throw new IllegalArgumentException("Annotation @RegistryProperties on " + ip.getMember() + " is missing non-empty 'value' attribute");
        }
        Properties properties = new Properties();
        Config config = ConfigProviderResolver.instance().getConfig();
        if (debug && log.isDebugEnabled()) {
            String dump = StreamSupport.stream(config.getPropertyNames().spliterator(), false).sorted().map(key -> key + "=" + config.getOptionalValue(key, String.class).orElse("")).collect(Collectors.joining("\n  ", "  ", "\n"));
            log.debug("Injecting config properties with prefixes {} into {} from the following...\n{}", new Object[]{Arrays.toString(prefixes), ip.getMember(), dump});
        }
        HashMap<String, String> defaults = new HashMap<String, String>();
        if (cp != null) {
            void var9_11;
            Object[] empties;
            Object[] objectArray = empties = cp.empties();
            int n = objectArray.length;
            boolean i = false;
            while (var9_11 < n) {
                String e = objectArray[var9_11];
                int p = e.indexOf("=");
                defaults.put(e.substring(0, p), e.substring(p + 1));
                ++var9_11;
            }
        }
        for (String string : prefixes) {
            for (String key2 : config.getPropertyNames()) {
                String sKey;
                String defaultValue;
                if (!key2.startsWith(string)) continue;
                Optional value = config.getOptionalValue(key2, String.class);
                if (value.isPresent()) {
                    properties.put(key2.substring(string.length()), value.get());
                    continue;
                }
                if (defaults.size() <= 0 || (defaultValue = (String)defaults.get(sKey = key2.substring(string.length()))) == null) continue;
                properties.put(sKey, defaultValue);
            }
        }
        if (debug && log.isDebugEnabled()) {
            String dump = properties.stringPropertyNames().stream().sorted().map(key -> key + "=" + properties.getProperty((String)key)).collect(Collectors.joining("\n  ", "  ", "\n"));
            log.debug("... selected/prefix-stripped properties are:\n{}", (Object)dump);
        }
        return properties;
    }
}

