/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.apicurio.common.apps.config.ConfigPropertyCategory;
import io.apicurio.common.apps.config.Info;
import io.quarkus.jackson.ObjectMapperCustomizer;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Singleton;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class JacksonDateTimeCustomizer
implements ObjectMapperCustomizer {
    private static Logger log = LoggerFactory.getLogger(JacksonDateTimeCustomizer.class);
    private static final String DEFAULT_DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final String DEFAULT_DATE_TIME_FORMAT_TZ = "UTC";
    @ConfigProperty(name="apicurio.apis.date-format", defaultValue="yyyy-MM-dd'T'HH:mm:ss'Z'")
    @Info(category=ConfigPropertyCategory.CATEGORY_API, description="API date format", availableSince="2.4.3.Final")
    String dateFormat;
    @ConfigProperty(name="apicurio.apis.date-format-timezone", defaultValue="UTC")
    @Info(category=ConfigPropertyCategory.CATEGORY_API, description="API date format (TZ)", availableSince="2.4.3.Final")
    String timezone;

    @PostConstruct
    protected void postConstruct() {
        log.debug("---------------------------------------------------------------------");
        log.debug("Overriding REST API date format.  Using: " + this.dateFormat);
        log.debug("---------------------------------------------------------------------");
    }

    public void customize(ObjectMapper mapper) {
        try {
            JacksonDateTimeCustomizer.configureDateFormat(mapper, this.dateFormat, this.timezone);
        }
        catch (Exception e) {
            log.error("Error setting REST API date format.", (Throwable)e);
            JacksonDateTimeCustomizer.configureDateFormat(mapper, DEFAULT_DATE_TIME_FORMAT, DEFAULT_DATE_TIME_FORMAT_TZ);
        }
    }

    protected static void configureDateFormat(ObjectMapper mapper, String format, String tz) {
        SimpleDateFormat df = new SimpleDateFormat(format);
        df.setTimeZone(TimeZone.getTimeZone(tz));
        mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        mapper.setDateFormat((DateFormat)df);
    }
}

