/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest.client.search.versions;

import com.microsoft.kiota.BaseRequestBuilder;
import com.microsoft.kiota.BaseRequestConfiguration;
import com.microsoft.kiota.HttpMethod;
import com.microsoft.kiota.QueryParameters;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.serialization.ParsableFactory;
import io.apicurio.registry.rest.client.models.Error;
import io.apicurio.registry.rest.client.models.SortOrder;
import io.apicurio.registry.rest.client.models.VersionSearchResults;
import io.apicurio.registry.rest.client.models.VersionSortBy;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class VersionsRequestBuilder
extends BaseRequestBuilder {
    public VersionsRequestBuilder(@Nonnull HashMap<String, Object> pathParameters, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/search/versions{?version*,offset*,limit*,order*,orderby*,labels*,description*,groupId*,globalId*,contentId*,artifactId*,name*,canonical*,artifactType*}", pathParameters);
    }

    public VersionsRequestBuilder(@Nonnull String rawUrl, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/search/versions{?version*,offset*,limit*,order*,orderby*,labels*,description*,groupId*,globalId*,contentId*,artifactId*,name*,canonical*,artifactType*}", rawUrl);
    }

    @Nullable
    public VersionSearchResults get() {
        return this.get(null);
    }

    @Nullable
    public VersionSearchResults get(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = this.toGetRequestInformation(requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("500", Error::createFromDiscriminatorValue);
        return (VersionSearchResults)this.requestAdapter.send(requestInfo, errorMapping, VersionSearchResults::createFromDiscriminatorValue);
    }

    @Nullable
    public VersionSearchResults post(@Nonnull InputStream body, @Nonnull String contentType) {
        return this.post(body, contentType, null);
    }

    @Nullable
    public VersionSearchResults post(@Nonnull InputStream body, @Nonnull String contentType, @Nullable Consumer<PostRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        Objects.requireNonNull(contentType);
        RequestInformation requestInfo = this.toPostRequestInformation(body, contentType, requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("400", Error::createFromDiscriminatorValue);
        errorMapping.put("500", Error::createFromDiscriminatorValue);
        return (VersionSearchResults)this.requestAdapter.send(requestInfo, errorMapping, VersionSearchResults::createFromDiscriminatorValue);
    }

    @Nonnull
    public RequestInformation toGetRequestInformation() {
        return this.toGetRequestInformation(null);
    }

    @Nonnull
    public RequestInformation toGetRequestInformation(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = new RequestInformation(HttpMethod.GET, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new GetRequestConfiguration(), x -> x.queryParameters);
        requestInfo.headers.tryAdd("Accept", "application/json");
        return requestInfo;
    }

    @Nonnull
    public RequestInformation toPostRequestInformation(@Nonnull InputStream body, @Nonnull String contentType) {
        return this.toPostRequestInformation(body, contentType, null);
    }

    @Nonnull
    public RequestInformation toPostRequestInformation(@Nonnull InputStream body, @Nonnull String contentType, @Nullable Consumer<PostRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        Objects.requireNonNull(contentType);
        RequestInformation requestInfo = new RequestInformation(HttpMethod.POST, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new PostRequestConfiguration(), x -> x.queryParameters);
        requestInfo.headers.tryAdd("Accept", "application/json");
        requestInfo.setStreamContent(body, contentType);
        return requestInfo;
    }

    @Nonnull
    public VersionsRequestBuilder withUrl(@Nonnull String rawUrl) {
        Objects.requireNonNull(rawUrl);
        return new VersionsRequestBuilder(rawUrl, this.requestAdapter);
    }

    public class PostRequestConfiguration
    extends BaseRequestConfiguration {
        @Nullable
        public PostQueryParameters queryParameters;

        public PostRequestConfiguration() {
            this.queryParameters = new PostQueryParameters();
        }
    }

    public class PostQueryParameters
    implements QueryParameters {
        @Nullable
        public String artifactId;
        @Nullable
        public String artifactType;
        @Nullable
        public Boolean canonical;
        @Nullable
        public String groupId;
        @Nullable
        public Integer limit;
        @Nullable
        public Integer offset;
        @Nullable
        public SortOrder order;
        @Nullable
        public VersionSortBy orderby;

        @Nonnull
        public Map<String, Object> toQueryParameters() {
            HashMap<String, Object> allQueryParams = new HashMap<String, Object>();
            allQueryParams.put("order", (Object)this.order);
            allQueryParams.put("orderby", (Object)this.orderby);
            allQueryParams.put("artifactId", this.artifactId);
            allQueryParams.put("artifactType", this.artifactType);
            allQueryParams.put("canonical", this.canonical);
            allQueryParams.put("groupId", this.groupId);
            allQueryParams.put("limit", this.limit);
            allQueryParams.put("offset", this.offset);
            return allQueryParams;
        }
    }

    public class GetRequestConfiguration
    extends BaseRequestConfiguration {
        @Nullable
        public GetQueryParameters queryParameters;

        public GetRequestConfiguration() {
            this.queryParameters = new GetQueryParameters();
        }
    }

    public class GetQueryParameters
    implements QueryParameters {
        @Nullable
        public String artifactId;
        @Nullable
        public Long contentId;
        @Nullable
        public String description;
        @Nullable
        public Long globalId;
        @Nullable
        public String groupId;
        @Nullable
        public String[] labels;
        @Nullable
        public Integer limit;
        @Nullable
        public String name;
        @Nullable
        public Integer offset;
        @Nullable
        public SortOrder order;
        @Nullable
        public VersionSortBy orderby;
        @Nullable
        public String version;

        @Nonnull
        public Map<String, Object> toQueryParameters() {
            HashMap<String, Object> allQueryParams = new HashMap<String, Object>();
            allQueryParams.put("order", (Object)this.order);
            allQueryParams.put("orderby", (Object)this.orderby);
            allQueryParams.put("artifactId", this.artifactId);
            allQueryParams.put("contentId", this.contentId);
            allQueryParams.put("description", this.description);
            allQueryParams.put("globalId", this.globalId);
            allQueryParams.put("groupId", this.groupId);
            allQueryParams.put("limit", this.limit);
            allQueryParams.put("name", this.name);
            allQueryParams.put("offset", this.offset);
            allQueryParams.put("version", this.version);
            allQueryParams.put("labels", this.labels);
            return allQueryParams;
        }
    }
}

