/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.maven;

import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.internal.parser.ProtoFileElement;
import com.squareup.wire.schema.internal.parser.ProtoParser;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.maven.AbstractDirectoryParser;
import io.apicurio.registry.maven.ParsedDirectoryWrapper;
import io.apicurio.registry.maven.RegisterArtifact;
import io.apicurio.registry.rest.client.RegistryClient;
import io.apicurio.registry.rest.v2.beans.ArtifactReference;
import io.apicurio.registry.utils.protobuf.schema.FileDescriptorUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtobufDirectoryParser
extends AbstractDirectoryParser<Descriptors.FileDescriptor> {
    private static final String PROTO_SCHEMA_EXTENSION = ".proto";
    private static final Logger log = LoggerFactory.getLogger(ProtobufDirectoryParser.class);

    public ProtobufDirectoryParser(RegistryClient client) {
        super(client);
    }

    @Override
    public ParsedDirectoryWrapper<Descriptors.FileDescriptor> parse(File protoFile) {
        Set protoFiles = Arrays.stream(Objects.requireNonNull(protoFile.getParentFile().listFiles((dir, name) -> name.endsWith(PROTO_SCHEMA_EXTENSION)))).filter(file -> !file.getName().equals(protoFile.getName())).collect(Collectors.toSet());
        HashMap<String, Descriptors.FileDescriptor> parsedFiles = new HashMap<String, Descriptors.FileDescriptor>();
        HashMap<String, ContentHandle> schemaDefs = new HashMap<String, ContentHandle>();
        while (parsedFiles.size() != protoFiles.size()) {
            boolean fileParsed = false;
            for (File fileToProcess : protoFiles) {
                if (fileToProcess.getName().equals(protoFile.getName()) || parsedFiles.containsKey(fileToProcess.getName())) continue;
                try {
                    ContentHandle schemaContent = this.readSchemaContent(fileToProcess);
                    parsedFiles.put(fileToProcess.getName(), this.parseProtoFile(fileToProcess, schemaDefs, parsedFiles, schemaContent));
                    schemaDefs.put(fileToProcess.getName(), schemaContent);
                    fileParsed = true;
                }
                catch (Exception ex) {
                    log.warn("Error processing Avro schema with name {}. This usually means that the references are not ready yet to parse it", (Object)fileToProcess.getName());
                }
            }
            if (fileParsed) continue;
            throw new IllegalStateException("Error found in the directory structure. Check that all required files are present.");
        }
        ContentHandle schemaContent = this.readSchemaContent(protoFile);
        Descriptors.FileDescriptor schemaDescriptor = this.parseProtoFile(protoFile, schemaDefs, parsedFiles, schemaContent);
        return new DescriptorWrapper(schemaDescriptor, schemaDefs);
    }

    @Override
    public List<ArtifactReference> handleSchemaReferences(RegisterArtifact rootArtifact, Descriptors.FileDescriptor protoSchema, Map<String, ContentHandle> fileContents) throws FileNotFoundException {
        HashSet<ArtifactReference> references = new HashSet<ArtifactReference>();
        HashSet<Descriptors.FileDescriptor> baseDeps = new HashSet<Descriptors.FileDescriptor>(Arrays.asList(FileDescriptorUtils.baseDependencies()));
        ProtoFileElement rootSchemaElement = FileDescriptorUtils.fileDescriptorToProtoFile((DescriptorProtos.FileDescriptorProto)protoSchema.toProto());
        for (Descriptors.FileDescriptor dependency : protoSchema.getDependencies()) {
            List<ArtifactReference> nestedArtifactReferences = new ArrayList<ArtifactReference>();
            String dependencyFullName = dependency.getPackage() + "/" + dependency.getName();
            if (baseDeps.contains(dependency) || !rootSchemaElement.getImports().contains(dependencyFullName)) continue;
            RegisterArtifact nestedArtifact = this.buildFromRoot(rootArtifact, dependencyFullName);
            if (!dependency.getDependencies().isEmpty()) {
                nestedArtifactReferences = this.handleSchemaReferences(nestedArtifact, dependency, fileContents);
            }
            references.add(this.registerNestedSchema(dependencyFullName, nestedArtifactReferences, nestedArtifact, fileContents.get(dependency.getName()).content()));
        }
        return new ArrayList<ArtifactReference>(references);
    }

    private Descriptors.FileDescriptor parseProtoFile(File protoFile, Map<String, ContentHandle> schemaDefs, Map<String, Descriptors.FileDescriptor> dependencies, ContentHandle schemaContent) {
        ProtoFileElement protoFileElement = ProtoParser.Companion.parse(Location.get((String)protoFile.getAbsolutePath()), schemaContent.content());
        try {
            Map<String, String> schemaStrings = schemaDefs.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((ContentHandle)e.getValue()).content()));
            return FileDescriptorUtils.protoFileToFileDescriptor((String)schemaContent.content(), (String)protoFile.getName(), Optional.ofNullable(protoFileElement.getPackageName()), schemaStrings, dependencies);
        }
        catch (Descriptors.DescriptorValidationException e2) {
            throw new RuntimeException("Failed to read schema file: " + protoFile, e2);
        }
    }

    public static class DescriptorWrapper
    implements ParsedDirectoryWrapper<Descriptors.FileDescriptor> {
        final Descriptors.FileDescriptor fileDescriptor;
        final Map<String, ContentHandle> schemaContents;

        public DescriptorWrapper(Descriptors.FileDescriptor fileDescriptor, Map<String, ContentHandle> schemaContents) {
            this.fileDescriptor = fileDescriptor;
            this.schemaContents = schemaContents;
        }

        @Override
        public Descriptors.FileDescriptor getSchema() {
            return this.fileDescriptor;
        }

        @Override
        public Map<String, ContentHandle> getSchemaContents() {
            return this.schemaContents;
        }
    }
}

