/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.maven;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.Descriptors;
import io.apicurio.registry.maven.AbstractRegistryMojo;
import io.apicurio.registry.maven.AvroDirectoryParser;
import io.apicurio.registry.maven.JsonSchemaDirectoryParser;
import io.apicurio.registry.maven.ParsedDirectoryWrapper;
import io.apicurio.registry.maven.ProtobufDirectoryParser;
import io.apicurio.registry.maven.RegisterArtifact;
import io.apicurio.registry.maven.RegisterArtifactReference;
import io.apicurio.registry.rest.v2.beans.ArtifactMetaData;
import io.apicurio.registry.rest.v2.beans.ArtifactReference;
import io.apicurio.registry.rest.v2.beans.IfExists;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="register")
public class RegisterRegistryMojo
extends AbstractRegistryMojo {
    @Parameter(required=true)
    List<RegisterArtifact> artifacts;

    protected void validate() throws MojoExecutionException {
        if (this.artifacts == null || this.artifacts.isEmpty()) {
            this.getLog().warn((CharSequence)"No artifacts are configured for registration.");
        } else {
            int idx = 0;
            int errorCount = 0;
            for (RegisterArtifact artifact : this.artifacts) {
                if (artifact.getGroupId() == null) {
                    this.getLog().error((CharSequence)String.format("GroupId is required when registering an artifact.  Missing from artifacts[%d].", idx));
                    ++errorCount;
                }
                if (artifact.getArtifactId() == null) {
                    this.getLog().error((CharSequence)String.format("ArtifactId is required when registering an artifact.  Missing from artifacts[%s].", idx));
                    ++errorCount;
                }
                if (artifact.getFile() == null) {
                    this.getLog().error((CharSequence)String.format("File is required when registering an artifact.  Missing from artifacts[%s].", idx));
                    ++errorCount;
                } else if (!artifact.getFile().exists()) {
                    this.getLog().error((CharSequence)String.format("Artifact file to register is configured but file does not exist: %s", artifact.getFile().getPath()));
                    ++errorCount;
                }
                ++idx;
            }
            if (errorCount > 0) {
                throw new MojoExecutionException("Invalid configuration of the Register Artifact(s) mojo. See the output log for details.");
            }
        }
    }

    @Override
    protected void executeInternal() throws MojoExecutionException {
        this.validate();
        int errorCount = 0;
        if (this.artifacts != null) {
            for (RegisterArtifact artifact : this.artifacts) {
                String groupId = artifact.getGroupId();
                String artifactId = artifact.getArtifactId();
                try {
                    if (artifact.getAnalyzeDirectory() != null && artifact.getAnalyzeDirectory().booleanValue()) {
                        this.registerDirectory(artifact);
                        continue;
                    }
                    List<ArtifactReference> references = new ArrayList<ArtifactReference>();
                    if (this.hasReferences(artifact)) {
                        references = this.registerArtifactReferences(artifact.getReferences());
                    }
                    this.registerArtifact(artifact, references);
                }
                catch (Exception e) {
                    ++errorCount;
                    this.getLog().error((CharSequence)String.format("Exception while registering artifact [%s] / [%s]", groupId, artifactId), (Throwable)e);
                }
            }
            if (errorCount > 0) {
                throw new MojoExecutionException("Errors while registering artifacts ...");
            }
        }
    }

    private void registerDirectory(RegisterArtifact artifact) throws IOException {
        switch (artifact.getType()) {
            case "AVRO": {
                AvroDirectoryParser avroDirectoryParser = new AvroDirectoryParser(this.getClient());
                ParsedDirectoryWrapper<Schema> schema = avroDirectoryParser.parse(artifact.getFile());
                this.registerArtifact(artifact, avroDirectoryParser.handleSchemaReferences(artifact, schema.getSchema(), schema.getSchemaContents()));
                break;
            }
            case "PROTOBUF": {
                ProtobufDirectoryParser protobufDirectoryParser = new ProtobufDirectoryParser(this.getClient());
                ParsedDirectoryWrapper<Descriptors.FileDescriptor> protoSchema = protobufDirectoryParser.parse(artifact.getFile());
                this.registerArtifact(artifact, protobufDirectoryParser.handleSchemaReferences(artifact, protoSchema.getSchema(), protoSchema.getSchemaContents()));
                break;
            }
            case "JSON": {
                JsonSchemaDirectoryParser jsonSchemaDirectoryParser = new JsonSchemaDirectoryParser(this.getClient());
                ParsedDirectoryWrapper<org.everit.json.schema.Schema> jsonSchema = jsonSchemaDirectoryParser.parse(artifact.getFile());
                this.registerArtifact(artifact, jsonSchemaDirectoryParser.handleSchemaReferences(artifact, jsonSchema.getSchema(), jsonSchema.getSchemaContents()));
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Artifact type not recognized for analyzing a directory structure %s", artifact.getType()));
            }
        }
    }

    private ArtifactMetaData registerArtifact(RegisterArtifact artifact, List<ArtifactReference> references) throws FileNotFoundException {
        return this.registerArtifact(artifact, new FileInputStream(artifact.getFile()), references);
    }

    private ArtifactMetaData registerArtifact(RegisterArtifact artifact, InputStream artifactContent, List<ArtifactReference> references) {
        String groupId = artifact.getGroupId();
        String artifactId = artifact.getArtifactId();
        String version = artifact.getVersion();
        String type = artifact.getType();
        IfExists ifExists = artifact.getIfExists();
        Boolean canonicalize = artifact.getCanonicalize();
        if (artifact.getMinify() != null && artifact.getMinify().booleanValue()) {
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode jsonNode = (JsonNode)objectMapper.readValue(artifactContent, JsonNode.class);
                artifactContent = new ByteArrayInputStream(jsonNode.toString().getBytes());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        ArtifactMetaData amd = this.getClient().createArtifact(groupId, artifactId, version, type, ifExists, canonicalize, null, null, "application/create.extended+json", null, null, artifactContent, references);
        this.getLog().info((CharSequence)String.format("Successfully registered artifact [%s] / [%s].  GlobalId is [%d]", groupId, artifactId, amd.getGlobalId()));
        return amd;
    }

    private boolean hasReferences(RegisterArtifact artifact) {
        return artifact.getReferences() != null && !artifact.getReferences().isEmpty();
    }

    private List<ArtifactReference> registerArtifactReferences(List<RegisterArtifactReference> referencedArtifacts) throws FileNotFoundException {
        ArrayList<ArtifactReference> references = new ArrayList<ArtifactReference>();
        for (RegisterArtifactReference artifact : referencedArtifacts) {
            List<ArtifactReference> nestedReferences = new ArrayList<ArtifactReference>();
            if (this.hasReferences(artifact)) {
                nestedReferences = this.registerArtifactReferences(artifact.getReferences());
            }
            ArtifactMetaData artifactMetaData = this.registerArtifact(artifact, nestedReferences);
            references.add(this.buildReferenceFromMetadata(artifactMetaData, artifact.getName()));
        }
        return references;
    }

    private ArtifactReference buildReferenceFromMetadata(ArtifactMetaData amd, String referenceName) {
        ArtifactReference reference = new ArtifactReference();
        reference.setName(referenceName);
        reference.setArtifactId(amd.getId());
        reference.setGroupId(amd.getGroupId());
        reference.setVersion(amd.getVersion());
        return reference;
    }

    private String contentType(RegisterArtifact registerArtifact) {
        String contentType = registerArtifact.getContentType();
        if (contentType != null) {
            return contentType;
        }
        return this.getContentTypeByExtension(registerArtifact.getFile().getName());
    }

    public void setArtifacts(List<RegisterArtifact> artifacts) {
        this.artifacts = artifacts;
    }
}

