/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.maven;

import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.content.TypedContent;
import io.apicurio.registry.maven.AbstractDirectoryParser;
import io.apicurio.registry.maven.ParsedDirectoryWrapper;
import io.apicurio.registry.maven.RegisterArtifact;
import io.apicurio.registry.rest.client.RegistryClient;
import io.apicurio.registry.rest.client.models.ArtifactReference;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.avro.AvroTypeException;
import org.apache.avro.Schema;
import org.apache.avro.SchemaParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroDirectoryParser
extends AbstractDirectoryParser<Schema> {
    private static final String AVRO_SCHEMA_EXTENSION = ".avsc";
    private static final Logger log = LoggerFactory.getLogger(AvroDirectoryParser.class);

    public AvroDirectoryParser(RegistryClient client) {
        super(client);
    }

    @Override
    public ParsedDirectoryWrapper<Schema> parse(File rootSchemaFile) {
        return this.parseDirectory(rootSchemaFile.getParentFile(), rootSchemaFile);
    }

    @Override
    public List<ArtifactReference> handleSchemaReferences(RegisterArtifact rootArtifact, Schema rootSchema, Map<String, TypedContent> fileContents) throws FileNotFoundException, ExecutionException, InterruptedException {
        HashSet<ArtifactReference> references = new HashSet<ArtifactReference>();
        for (Schema.Field field : rootSchema.getFields()) {
            RegisterArtifact nestedSchema;
            List<ArtifactReference> nestedArtifactReferences = new ArrayList<ArtifactReference>();
            if (field.schema().getType() == Schema.Type.RECORD) {
                nestedSchema = this.buildFromRoot(rootArtifact, field.schema().getFullName());
                if (field.schema().hasFields()) {
                    nestedArtifactReferences = this.handleSchemaReferences(nestedSchema, field.schema(), fileContents);
                }
                references.add(this.registerNestedSchema(field.schema().getFullName(), nestedArtifactReferences, nestedSchema, fileContents.get(field.schema().getFullName()).getContent().content()));
                continue;
            }
            if (field.schema().getType() == Schema.Type.ENUM) {
                nestedSchema = this.buildFromRoot(rootArtifact, field.schema().getFullName());
                references.add(this.registerNestedSchema(field.schema().getFullName(), nestedArtifactReferences, nestedSchema, fileContents.get(field.schema().getFullName()).getContent().content()));
                continue;
            }
            if (!this.isArrayWithSubschemaElement(field)) continue;
            Schema elementSchema = field.schema().getElementType();
            RegisterArtifact nestedSchema2 = this.buildFromRoot(rootArtifact, elementSchema.getFullName());
            if (elementSchema.hasFields()) {
                nestedArtifactReferences = this.handleSchemaReferences(nestedSchema2, elementSchema, fileContents);
            }
            references.add(this.registerNestedSchema(elementSchema.getFullName(), nestedArtifactReferences, nestedSchema2, fileContents.get(elementSchema.getFullName()).getContent().content()));
        }
        return new ArrayList<ArtifactReference>(references);
    }

    private ParsedDirectoryWrapper<Schema> parseDirectory(File directory, File rootSchema) {
        Set typesToAdd = Arrays.stream(Objects.requireNonNull(directory.listFiles((dir, name) -> name.endsWith(AVRO_SCHEMA_EXTENSION)))).filter(file -> !file.getName().equals(rootSchema.getName())).collect(Collectors.toSet());
        HashMap<String, Schema> processed = new HashMap<String, Schema>();
        HashMap<String, TypedContent> schemaContents = new HashMap<String, TypedContent>();
        Schema.Parser rootSchemaParser = new Schema.Parser();
        Schema.Parser partialParser = new Schema.Parser();
        while (processed.size() != typesToAdd.size()) {
            boolean fileParsed = false;
            for (File typeToAdd : typesToAdd) {
                if (typeToAdd.getName().equals(rootSchema.getName())) continue;
                try {
                    ContentHandle schemaContent = this.readSchemaContent(typeToAdd);
                    String contentType = "application/json";
                    TypedContent typedSchemaContent = TypedContent.create((ContentHandle)schemaContent, (String)"application/json");
                    Schema schema = partialParser.parse(schemaContent.content());
                    processed.put(schema.getFullName(), schema);
                    schemaContents.put(schema.getFullName(), typedSchemaContent);
                    fileParsed = true;
                }
                catch (AvroTypeException | SchemaParseException ex) {
                    log.warn("Error processing Avro schema with name {}. This usually means that the references are not ready yet to parse it", (Object)typeToAdd.getName());
                }
            }
            partialParser = new Schema.Parser();
            partialParser.addTypes(processed);
            if (fileParsed) continue;
            throw new IllegalStateException("Error found in the directory structure. Check that all required files are present.");
        }
        rootSchemaParser.addTypes(processed);
        return new AvroSchemaWrapper(rootSchemaParser.parse(this.readSchemaContent(rootSchema).content()), schemaContents);
    }

    private boolean isArrayWithSubschemaElement(Schema.Field field) {
        return field.schema().getType() == Schema.Type.ARRAY && field.schema().getElementType().getType() == Schema.Type.RECORD;
    }

    public static class AvroSchemaWrapper
    implements ParsedDirectoryWrapper<Schema> {
        final Schema schema;
        final Map<String, TypedContent> fileContents;

        public AvroSchemaWrapper(Schema schema, Map<String, TypedContent> fileContents) {
            this.schema = schema;
            this.fileContents = fileContents;
        }

        @Override
        public Schema getSchema() {
            return this.schema;
        }

        @Override
        public Map<String, TypedContent> getSchemaContents() {
            return this.fileContents;
        }
    }
}

