/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.maven;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.content.TypedContent;
import io.apicurio.registry.maven.AbstractDirectoryParser;
import io.apicurio.registry.maven.ParsedDirectoryWrapper;
import io.apicurio.registry.maven.RegisterArtifact;
import io.apicurio.registry.rest.client.RegistryClient;
import io.apicurio.registry.rest.client.models.ArtifactReference;
import io.apicurio.registry.rules.ParsedJsonSchema;
import io.apicurio.registry.rules.compatibility.jsonschema.JsonUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.everit.json.schema.ArraySchema;
import org.everit.json.schema.ObjectSchema;
import org.everit.json.schema.ReferenceSchema;
import org.everit.json.schema.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSchemaDirectoryParser
extends AbstractDirectoryParser<ParsedJsonSchema> {
    private static final String JSON_SCHEMA_EXTENSION = ".json";
    private static final Logger log = LoggerFactory.getLogger(JsonSchemaDirectoryParser.class);

    public JsonSchemaDirectoryParser(RegistryClient client) {
        super(client);
    }

    @Override
    public ParsedDirectoryWrapper<ParsedJsonSchema> parse(File rootSchemaFile) {
        return this.parseDirectory(rootSchemaFile.getParentFile(), rootSchemaFile);
    }

    @Override
    public List<ArtifactReference> handleSchemaReferences(RegisterArtifact rootArtifact, ParsedJsonSchema someRootSchema, Map<String, TypedContent> fileContents) throws FileNotFoundException, ExecutionException, InterruptedException {
        if (someRootSchema.getJsonsKema() != null) {
            log.warn("Reference handling for JSON schema version 2020-12 is not supported yet.");
            return List.of();
        }
        Schema rootSchema = someRootSchema.getEverit();
        if (rootSchema instanceof ObjectSchema) {
            ObjectSchema objectSchema = (ObjectSchema)rootSchema;
            HashSet<ArtifactReference> references = new HashSet<ArtifactReference>();
            Map rootSchemaPropertySchemas = objectSchema.getPropertySchemas();
            for (String schemaKey : rootSchemaPropertySchemas.keySet()) {
                ArraySchema arraySchema;
                List<ArtifactReference> nestedArtifactReferences = new ArrayList<ArtifactReference>();
                if (rootSchemaPropertySchemas.get(schemaKey) instanceof ReferenceSchema) {
                    ReferenceSchema nestedSchema = (ReferenceSchema)rootSchemaPropertySchemas.get(schemaKey);
                    RegisterArtifact nestedRegisterArtifact = this.buildFromRoot(rootArtifact, nestedSchema.getSchemaLocation());
                    if (nestedSchema.getReferredSchema() instanceof ObjectSchema) {
                        ObjectSchema nestedObjectSchema = (ObjectSchema)nestedSchema.getReferredSchema();
                        nestedArtifactReferences = this.handleSchemaReferences(nestedRegisterArtifact, new ParsedJsonSchema((Schema)nestedObjectSchema), fileContents);
                    }
                    references.add(this.registerNestedSchema(nestedSchema.getSchemaLocation(), nestedArtifactReferences, nestedRegisterArtifact, fileContents.get(nestedSchema.getSchemaLocation()).getContent().content()));
                    continue;
                }
                if (!(rootSchemaPropertySchemas.get(schemaKey) instanceof ArraySchema) || !((arraySchema = (ArraySchema)rootSchemaPropertySchemas.get(schemaKey)).getAllItemSchema() instanceof ReferenceSchema)) continue;
                ReferenceSchema arrayElementSchema = (ReferenceSchema)arraySchema.getAllItemSchema();
                RegisterArtifact nestedRegisterArtifact = this.buildFromRoot(rootArtifact, arrayElementSchema.getSchemaLocation());
                if (arrayElementSchema.getReferredSchema() instanceof ObjectSchema) {
                    nestedArtifactReferences = this.handleSchemaReferences(nestedRegisterArtifact, new ParsedJsonSchema((Schema)arrayElementSchema), fileContents);
                }
                references.add(this.registerNestedSchema(arrayElementSchema.getSchemaLocation(), nestedArtifactReferences, nestedRegisterArtifact, fileContents.get(arrayElementSchema.getSchemaLocation()).getContent().content()));
            }
            return new ArrayList<ArtifactReference>(references);
        }
        return Collections.emptyList();
    }

    private JsonSchemaWrapper parseDirectory(File directory, File rootSchema) {
        Set typesToAdd = Arrays.stream(Objects.requireNonNull(directory.listFiles((dir, name) -> name.endsWith(JSON_SCHEMA_EXTENSION)))).filter(file -> !file.getName().equals(rootSchema.getName())).collect(Collectors.toSet());
        HashMap<String, ParsedJsonSchema> processed = new HashMap<String, ParsedJsonSchema>();
        HashMap<String, TypedContent> schemaContents = new HashMap<String, TypedContent>();
        while (processed.size() != typesToAdd.size()) {
            boolean fileParsed = false;
            for (File typeToAdd : typesToAdd) {
                if (typeToAdd.getName().equals(rootSchema.getName())) continue;
                try {
                    ContentHandle schemaContent = this.readSchemaContent(typeToAdd);
                    TypedContent typedSchemaContent = TypedContent.create((ContentHandle)schemaContent, (String)"application/json");
                    ParsedJsonSchema schema = JsonUtil.readSchema((String)schemaContent.content(), schemaContents, (boolean)false);
                    processed.put(schema.getId(), schema);
                    schemaContents.put(schema.getId(), typedSchemaContent);
                    fileParsed = true;
                }
                catch (JsonProcessingException ex) {
                    log.warn("Error processing json schema with name {}. This usually means that the references are not ready yet to parse it", (Object)typeToAdd.getName());
                }
            }
            if (fileParsed) continue;
            throw new IllegalStateException("Error found in the directory structure. Check that all required files are present.");
        }
        try {
            return new JsonSchemaWrapper(JsonUtil.readSchema((String)this.readSchemaContent(rootSchema).content(), schemaContents, (boolean)false), schemaContents);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Unable to parse main schema", e);
        }
    }

    public static class JsonSchemaWrapper
    implements ParsedDirectoryWrapper<ParsedJsonSchema> {
        final ParsedJsonSchema schema;
        final Map<String, TypedContent> fileContents;

        public JsonSchemaWrapper(ParsedJsonSchema schema, Map<String, TypedContent> fileContents) {
            this.schema = schema;
            this.fileContents = fileContents;
        }

        @Override
        public ParsedJsonSchema getSchema() {
            return this.schema;
        }

        @Override
        public Map<String, TypedContent> getSchemaContents() {
            return this.fileContents;
        }
    }
}

