/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.maven;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.kiota.ApiException;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.content.TypedContent;
import io.apicurio.registry.content.refs.ExternalReference;
import io.apicurio.registry.content.refs.ReferenceArtifactIdentifierExtractor;
import io.apicurio.registry.content.refs.ReferenceFinder;
import io.apicurio.registry.maven.AbstractRegistryMojo;
import io.apicurio.registry.maven.ExistingReference;
import io.apicurio.registry.maven.RegisterArtifact;
import io.apicurio.registry.maven.RegisterArtifactReference;
import io.apicurio.registry.maven.refs.IndexedResource;
import io.apicurio.registry.maven.refs.ReferenceIndex;
import io.apicurio.registry.rest.client.RegistryClient;
import io.apicurio.registry.rest.client.models.ArtifactReference;
import io.apicurio.registry.rest.client.models.CreateArtifact;
import io.apicurio.registry.rest.client.models.CreateArtifactResponse;
import io.apicurio.registry.rest.client.models.CreateVersion;
import io.apicurio.registry.rest.client.models.IfArtifactExists;
import io.apicurio.registry.rest.client.models.ProblemDetails;
import io.apicurio.registry.rest.client.models.RuleViolationProblemDetails;
import io.apicurio.registry.rest.client.models.VersionContent;
import io.apicurio.registry.rest.client.models.VersionMetaData;
import io.apicurio.registry.types.provider.ArtifactTypeUtilProvider;
import io.apicurio.registry.types.provider.DefaultArtifactTypeUtilProviderImpl;
import io.vertx.core.Vertx;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="register")
public class RegisterRegistryMojo
extends AbstractRegistryMojo {
    @Parameter(required=false)
    List<ExistingReference> existingReferences;
    @Parameter(required=true)
    List<RegisterArtifact> artifacts;
    @Parameter(property="skipRegister", defaultValue="false")
    boolean skip;
    @Parameter(property="dryRun", defaultValue="false")
    boolean dryRun;
    private RegisterArtifact.AvroAutoRefsNamingStrategy avroAutoRefsNamingStrategy;
    DefaultArtifactTypeUtilProviderImpl utilProviderFactory = new DefaultArtifactTypeUtilProviderImpl(true);

    protected boolean validate() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"register is skipped.");
            return false;
        }
        if (this.artifacts == null || this.artifacts.isEmpty()) {
            this.getLog().warn((CharSequence)"No artifacts are configured for registration.");
            return false;
        }
        if (this.existingReferences == null) {
            this.existingReferences = new ArrayList<ExistingReference>();
        }
        int idx = 0;
        int errorCount = 0;
        for (RegisterArtifact artifact : this.artifacts) {
            if (artifact.getGroupId() == null) {
                this.getLog().error((CharSequence)String.format("GroupId is required when registering an artifact.  Missing from artifacts[%d].", idx));
                ++errorCount;
            }
            if (artifact.getArtifactId() == null) {
                this.getLog().error((CharSequence)String.format("ArtifactId is required when registering an artifact.  Missing from artifacts[%s].", idx));
                ++errorCount;
            }
            if (artifact.getFile() == null) {
                this.getLog().error((CharSequence)String.format("File is required when registering an artifact.  Missing from artifacts[%s].", idx));
                ++errorCount;
            } else if (!artifact.getFile().exists()) {
                this.getLog().error((CharSequence)String.format("Artifact file to register is configured but file does not exist: %s", artifact.getFile().getPath()));
                ++errorCount;
            }
            ++idx;
        }
        if (errorCount > 0) {
            throw new MojoExecutionException("Invalid configuration of the Register Artifact(s) mojo. See the output log for details.");
        }
        return true;
    }

    @Override
    protected void executeInternal() throws MojoExecutionException {
        int errorCount = 0;
        if (this.validate()) {
            Vertx vertx = this.createVertx();
            RegistryClient registryClient = this.createClient(vertx);
            for (RegisterArtifact artifact : this.artifacts) {
                String groupId = artifact.getGroupId();
                String artifactId = artifact.getArtifactId();
                try {
                    if (artifact.getAutoRefs() != null && artifact.getAutoRefs().booleanValue()) {
                        ReferenceIndex index = RegisterRegistryMojo.createIndex(artifact);
                        this.addExistingReferencesToIndex(registryClient, index, this.existingReferences);
                        this.addExistingReferencesToIndex(registryClient, index, artifact.getExistingReferences());
                        Stack<RegisterArtifact> registrationStack = new Stack<RegisterArtifact>();
                        this.avroAutoRefsNamingStrategy = artifact.getAvroAutoRefsNamingStrategy();
                        this.registerWithAutoRefs(registryClient, artifact, index, registrationStack);
                        continue;
                    }
                    List<ArtifactReference> references = new ArrayList<ArtifactReference>();
                    if (RegisterRegistryMojo.hasReferences(artifact)) {
                        references = this.processArtifactReferences(registryClient, artifact.getReferences());
                    }
                    this.registerArtifact(registryClient, artifact, references);
                }
                catch (Exception e) {
                    ++errorCount;
                    this.getLog().error((CharSequence)String.format("Exception while registering artifact [%s] / [%s]", groupId, artifactId), (Throwable)e);
                }
            }
            if (errorCount > 0) {
                throw new MojoExecutionException("Errors while registering artifacts ...");
            }
        }
    }

    private VersionMetaData registerWithAutoRefs(RegistryClient registryClient, RegisterArtifact artifact, ReferenceIndex index, Stack<RegisterArtifact> registrationStack) throws IOException, ExecutionException, InterruptedException, MojoExecutionException, MojoFailureException {
        if (RegisterRegistryMojo.loopDetected(artifact, registrationStack)) {
            throw new MojoExecutionException("Artifact reference loop detected (not supported): " + RegisterRegistryMojo.printLoop(registrationStack));
        }
        registrationStack.push(artifact);
        ContentHandle artifactContent = RegisterRegistryMojo.readContent(artifact.getFile());
        String artifactContentType = this.getContentTypeByExtension(artifact.getFile().getName());
        TypedContent typedArtifactContent = TypedContent.create((ContentHandle)artifactContent, (String)artifactContentType);
        ArtifactTypeUtilProvider provider = this.utilProviderFactory.getArtifactTypeProvider(artifact.getArtifactType());
        ReferenceFinder referenceFinder = provider.getReferenceFinder();
        ReferenceArtifactIdentifierExtractor referenceArtifactIdentifierExtractor = provider.getReferenceArtifactIdentifierExtractor();
        Set externalReferences = referenceFinder.findExternalReferences(typedArtifactContent);
        ArrayList<ArtifactReference> registeredReferences = new ArrayList<ArtifactReference>(externalReferences.size());
        for (ExternalReference externalRef : externalReferences) {
            IndexedResource iresource = index.lookup(externalRef.getResource(), Paths.get(artifact.getFile().toURI()));
            if (iresource == null) {
                throw new MojoExecutionException("Reference could not be resolved.  From: " + artifact.getFile().getName() + "  To: " + externalRef.getFullReference());
            }
            if (!iresource.isRegistered()) {
                String groupId = artifact.getGroupId();
                String artifactId = referenceArtifactIdentifierExtractor.extractArtifactId(externalRef.getResource());
                if ("AVRO".equals(iresource.getType())) {
                    if (this.avroAutoRefsNamingStrategy == RegisterArtifact.AvroAutoRefsNamingStrategy.USE_AVRO_NAMESPACE) {
                        groupId = referenceArtifactIdentifierExtractor.extractGroupId(externalRef.getResource());
                        artifactId = referenceArtifactIdentifierExtractor.extractArtifactId(externalRef.getResource());
                    }
                    if (this.avroAutoRefsNamingStrategy == RegisterArtifact.AvroAutoRefsNamingStrategy.INHERIT_PARENT_GROUP) {
                        groupId = artifact.getGroupId();
                        artifactId = iresource.getResourceName();
                    }
                }
                File localFile = RegisterRegistryMojo.getLocalFile(iresource.getPath());
                RegisterArtifact refArtifact = RegisterRegistryMojo.buildFromRoot(artifact, artifactId, groupId);
                refArtifact.setArtifactType(iresource.getType());
                refArtifact.setVersion(null);
                refArtifact.setFile(localFile);
                refArtifact.setContentType(this.getContentTypeByExtension(localFile.getName()));
                try {
                    VersionMetaData car = this.registerWithAutoRefs(registryClient, refArtifact, index, registrationStack);
                    iresource.setRegistration(car);
                }
                catch (IOException | InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
            ArtifactReference reference = new ArtifactReference();
            reference.setName(externalRef.getFullReference());
            reference.setVersion(iresource.getRegistration().getVersion());
            reference.setGroupId(iresource.getRegistration().getGroupId());
            reference.setArtifactId(iresource.getRegistration().getArtifactId());
            registeredReferences.add(reference);
        }
        registeredReferences.sort((ref1, ref2) -> ref1.getName().compareTo(ref2.getName()));
        registrationStack.pop();
        return this.registerArtifact(registryClient, artifact, registeredReferences);
    }

    private VersionMetaData registerArtifact(RegistryClient registryClient, RegisterArtifact artifact, List<ArtifactReference> references) throws FileNotFoundException, ExecutionException, InterruptedException, MojoExecutionException, MojoFailureException {
        if (artifact.getFile() != null) {
            return this.registerArtifact(registryClient, artifact, new FileInputStream(artifact.getFile()), references);
        }
        return this.getArtifactVersionMetadata(registryClient, artifact);
    }

    private VersionMetaData getArtifactVersionMetadata(RegistryClient registryClient, RegisterArtifact artifact) {
        String groupId = artifact.getGroupId();
        String artifactId = artifact.getArtifactId();
        String version = artifact.getVersion();
        VersionMetaData amd = registryClient.groups().byGroupId(groupId).artifacts().byArtifactId(artifactId).versions().byVersionExpression(version).get();
        this.getLog().info((CharSequence)String.format("Successfully processed artifact [%s] / [%s].  GlobalId is [%d]", groupId, artifactId, amd.getGlobalId()));
        return amd;
    }

    private VersionMetaData registerArtifact(RegistryClient registryClient, RegisterArtifact artifact, InputStream artifactContent, List<ArtifactReference> references) throws ExecutionException, InterruptedException, MojoFailureException, MojoExecutionException {
        String groupId = artifact.getGroupId();
        String artifactId = artifact.getArtifactId();
        String version = artifact.getVersion();
        String type = artifact.getArtifactType();
        Boolean canonicalize = artifact.getCanonicalize();
        Boolean isDraft = artifact.getIsDraft();
        String ct = artifact.getContentType() == null ? "application/json" : artifact.getContentType();
        String data = null;
        try {
            if (artifact.getMinify() != null && artifact.getMinify().booleanValue()) {
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode jsonNode = (JsonNode)objectMapper.readValue(artifactContent, JsonNode.class);
                data = jsonNode.toString();
            } else {
                data = new String(artifactContent.readAllBytes(), StandardCharsets.UTF_8);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        CreateArtifact createArtifact = new CreateArtifact();
        createArtifact.setArtifactId(artifactId);
        createArtifact.setArtifactType(type);
        CreateVersion createVersion = new CreateVersion();
        createVersion.setVersion(version);
        createVersion.setIsDraft(isDraft);
        createArtifact.setFirstVersion(createVersion);
        VersionContent content = new VersionContent();
        content.setContent(data);
        content.setContentType(ct);
        content.setReferences(references.stream().map(r -> {
            ArtifactReference ref = new ArtifactReference();
            ref.setArtifactId(r.getArtifactId());
            ref.setGroupId(r.getGroupId());
            ref.setVersion(r.getVersion());
            ref.setName(r.getName());
            return ref;
        }).collect(Collectors.toList()));
        createVersion.setContent(content);
        try {
            CreateArtifactResponse vmd = registryClient.groups().byGroupId(groupId).artifacts().post(createArtifact, config -> {
                if (artifact.getIfExists() != null) {
                    config.queryParameters.ifExists = IfArtifactExists.forValue((String)artifact.getIfExists().value());
                    if (this.dryRun) {
                        config.queryParameters.dryRun = true;
                    }
                }
                config.queryParameters.canonical = canonicalize;
            });
            this.getLog().info((CharSequence)String.format("Successfully registered artifact [%s] / [%s].  GlobalId is [%d]", groupId, artifactId, vmd.getVersion().getGlobalId()));
            return vmd.getVersion();
        }
        catch (ProblemDetails | RuleViolationProblemDetails e) {
            if (Boolean.TRUE.equals(artifact.getIsDraft()) && e.getResponseStatusCode() == 409) {
                try {
                    registryClient.groups().byGroupId(groupId).artifacts().byArtifactId(artifactId).versions().byVersionExpression(version).content().put(content, config -> {});
                    this.getLog().info((CharSequence)String.format("Successfully updated artifact [%s] / [%s].", groupId, artifactId));
                    return registryClient.groups().byGroupId(groupId).artifacts().byArtifactId(artifactId).versions().byVersionExpression(version).get();
                }
                catch (ProblemDetails | RuleViolationProblemDetails pd) {
                    this.logAndThrow((ApiException)pd);
                    return null;
                }
            }
            this.logAndThrow((ApiException)e);
            return null;
        }
    }

    private static boolean hasReferences(RegisterArtifact artifact) {
        return artifact.getReferences() != null && !artifact.getReferences().isEmpty();
    }

    private List<ArtifactReference> processArtifactReferences(RegistryClient registryClient, List<RegisterArtifactReference> referencedArtifacts) throws FileNotFoundException, ExecutionException, InterruptedException, MojoExecutionException, MojoFailureException {
        ArrayList<ArtifactReference> references = new ArrayList<ArtifactReference>();
        for (RegisterArtifactReference artifact : referencedArtifacts) {
            List<ArtifactReference> nestedReferences = new ArrayList<ArtifactReference>();
            if (RegisterRegistryMojo.hasReferences(artifact)) {
                nestedReferences = this.processArtifactReferences(registryClient, artifact.getReferences());
            }
            VersionMetaData artifactMetaData = this.registerArtifact(registryClient, artifact, nestedReferences);
            references.add(RegisterRegistryMojo.buildReferenceFromMetadata(artifactMetaData, artifact.getName()));
        }
        return references;
    }

    public void setArtifacts(List<RegisterArtifact> artifacts) {
        this.artifacts = artifacts;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    private static ArtifactReference buildReferenceFromMetadata(VersionMetaData metaData, String referenceName) {
        ArtifactReference reference = new ArtifactReference();
        reference.setName(referenceName);
        reference.setArtifactId(metaData.getArtifactId());
        reference.setGroupId(metaData.getGroupId());
        reference.setVersion(metaData.getVersion());
        return reference;
    }

    private static boolean isFileAllowedInIndex(File file) {
        return file.isFile() && (file.getName().toLowerCase().endsWith(".json") || file.getName().toLowerCase().endsWith(".yml") || file.getName().toLowerCase().endsWith(".yaml") || file.getName().toLowerCase().endsWith(".xml") || file.getName().toLowerCase().endsWith(".xsd") || file.getName().toLowerCase().endsWith(".wsdl") || file.getName().toLowerCase().endsWith(".graphql") || file.getName().toLowerCase().endsWith(".avsc") || file.getName().toLowerCase().endsWith(".proto"));
    }

    private static ReferenceIndex createIndex(RegisterArtifact artifact) {
        File file = artifact.getFile();
        ReferenceIndex index = new ReferenceIndex(file.getParentFile().toPath());
        if (artifact.getProtoPaths() != null) {
            artifact.getProtoPaths().forEach(path -> index.addSchemaPath(path.toPath()));
        }
        HashSet<File> roots = new HashSet<File>();
        if (artifact.getProtoPaths() != null) {
            roots.addAll(artifact.getProtoPaths());
        } else {
            roots.add(file.getParentFile());
        }
        HashSet allFiles = new HashSet();
        for (File root : roots) {
            allFiles.addAll(FileUtils.listFiles((File)root, null, (boolean)true));
            allFiles.stream().filter(RegisterRegistryMojo::isFileAllowedInIndex).forEach(f -> index.index(f.toPath(), RegisterRegistryMojo.readContent(f)));
        }
        return index;
    }

    private void addExistingReferencesToIndex(RegistryClient registryClient, ReferenceIndex index, List<ExistingReference> existingReferences) throws ExecutionException, InterruptedException {
        if (existingReferences != null && !existingReferences.isEmpty()) {
            for (ExistingReference ref : existingReferences) {
                VersionMetaData vmd;
                if (ref.getVersion() == null || "LATEST".equalsIgnoreCase(ref.getVersion())) {
                    vmd = registryClient.groups().byGroupId(ref.getGroupId()).artifacts().byArtifactId(ref.getArtifactId()).versions().byVersionExpression("branch=latest").get();
                } else {
                    vmd = new VersionMetaData();
                    vmd.setGroupId(ref.getGroupId());
                    vmd.setArtifactId(ref.getArtifactId());
                    vmd.setVersion(ref.getVersion());
                }
                index.index(ref.getResourceName(), vmd);
            }
        }
    }

    protected static ContentHandle readContent(File file) {
        try {
            return ContentHandle.create((byte[])Files.readAllBytes(file.toPath()));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read schema file: " + String.valueOf(file), e);
        }
    }

    protected static RegisterArtifact buildFromRoot(RegisterArtifact rootArtifact, String artifactId, String groupId) {
        RegisterArtifact nestedSchema = new RegisterArtifact();
        nestedSchema.setCanonicalize(rootArtifact.getCanonicalize());
        nestedSchema.setArtifactId(artifactId);
        nestedSchema.setGroupId(groupId == null ? rootArtifact.getGroupId() : groupId);
        nestedSchema.setContentType(rootArtifact.getContentType());
        nestedSchema.setArtifactType(rootArtifact.getArtifactType());
        nestedSchema.setMinify(rootArtifact.getMinify());
        nestedSchema.setContentType(rootArtifact.getContentType());
        nestedSchema.setIfExists(rootArtifact.getIfExists());
        nestedSchema.setAutoRefs(rootArtifact.getAutoRefs());
        return nestedSchema;
    }

    private static File getLocalFile(Path path) {
        return path.toFile();
    }

    private static boolean loopDetected(RegisterArtifact artifact, Stack<RegisterArtifact> registrationStack) {
        for (RegisterArtifact stackArtifact : registrationStack) {
            if (!artifact.getFile().equals(stackArtifact.getFile())) continue;
            return true;
        }
        return false;
    }

    private static String printLoop(Stack<RegisterArtifact> registrationStack) {
        return registrationStack.stream().map(artifact -> artifact.getFile().getName()).collect(Collectors.joining(" -> "));
    }
}

