package io.apicurio.registry.operator.api.v1.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ApicurioRegistryBuilder extends ApicurioRegistryFluent<ApicurioRegistryBuilder> implements VisitableBuilder<ApicurioRegistry,ApicurioRegistryBuilder>{
  public ApicurioRegistryBuilder() {
    this(false);
  }
  public ApicurioRegistryBuilder(Boolean validationEnabled) {
    this(new ApicurioRegistry(), validationEnabled);
  }
  public ApicurioRegistryBuilder(ApicurioRegistryFluent<?> fluent) {
    this(fluent, false);
  }
  public ApicurioRegistryBuilder(ApicurioRegistryFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ApicurioRegistry(), validationEnabled);
  }
  public ApicurioRegistryBuilder(ApicurioRegistryFluent<?> fluent,ApicurioRegistry instance) {
    this(fluent, instance, false);
  }
  public ApicurioRegistryBuilder(ApicurioRegistryFluent<?> fluent,ApicurioRegistry instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ApicurioRegistry());

    if (instance != null) {
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withKind(instance.getKind());
      fluent.withApiVersion(instance.getApiVersion());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ApicurioRegistryBuilder(ApicurioRegistry instance) {
    this(instance,false);
  }
  public ApicurioRegistryBuilder(ApicurioRegistry instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ApicurioRegistry());

    if (instance != null) {
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withKind(instance.getKind());
      this.withApiVersion(instance.getApiVersion());
    }
    this.validationEnabled = validationEnabled; 
  }
  ApicurioRegistryFluent<?> fluent;
  Boolean validationEnabled;
  public ApicurioRegistry build() {
    ApicurioRegistry buildable = new ApicurioRegistry();
    buildable.setMetadata(fluent.buildMetadata());
    buildable.setSpec(fluent.buildSpec());
    buildable.setStatus(fluent.buildStatus());
    buildable.setKind(fluent.getKind());
    buildable.setApiVersion(fluent.getApiVersion());
    return buildable;
  }
  
}