package io.apicurio.registry.operator.api.v1.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ApicurioRegistryListBuilder extends ApicurioRegistryListFluent<ApicurioRegistryListBuilder> implements VisitableBuilder<ApicurioRegistryList,ApicurioRegistryListBuilder>{
  public ApicurioRegistryListBuilder() {
    this(false);
  }
  public ApicurioRegistryListBuilder(Boolean validationEnabled) {
    this(new ApicurioRegistryList(), validationEnabled);
  }
  public ApicurioRegistryListBuilder(ApicurioRegistryListFluent<?> fluent) {
    this(fluent, false);
  }
  public ApicurioRegistryListBuilder(ApicurioRegistryListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ApicurioRegistryList(), validationEnabled);
  }
  public ApicurioRegistryListBuilder(ApicurioRegistryListFluent<?> fluent,ApicurioRegistryList instance) {
    this(fluent, instance, false);
  }
  public ApicurioRegistryListBuilder(ApicurioRegistryListFluent<?> fluent,ApicurioRegistryList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ApicurioRegistryList());

    if (instance != null) {
      fluent.withMetadata(instance.getMetadata());
      fluent.withItems(instance.getItems());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ApicurioRegistryListBuilder(ApicurioRegistryList instance) {
    this(instance,false);
  }
  public ApicurioRegistryListBuilder(ApicurioRegistryList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ApicurioRegistryList());

    if (instance != null) {
      this.withMetadata(instance.getMetadata());
      this.withItems(instance.getItems());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
    }
    this.validationEnabled = validationEnabled; 
  }
  ApicurioRegistryListFluent<?> fluent;
  Boolean validationEnabled;
  public ApicurioRegistryList build() {
    ApicurioRegistryList buildable = new ApicurioRegistryList();
    buildable.setMetadata(fluent.getMetadata());
    buildable.setItems(fluent.buildItems());
    buildable.setApiVersion(fluent.getApiVersion());
    buildable.setKind(fluent.getKind());
    return buildable;
  }
  
}