package io.apicurio.registry.operator.api.v1.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ApicurioRegistrySpecBuilder extends ApicurioRegistrySpecFluent<ApicurioRegistrySpecBuilder> implements VisitableBuilder<ApicurioRegistrySpec,ApicurioRegistrySpecBuilder>{
  public ApicurioRegistrySpecBuilder() {
    this(false);
  }
  public ApicurioRegistrySpecBuilder(Boolean validationEnabled) {
    this(new ApicurioRegistrySpec(), validationEnabled);
  }
  public ApicurioRegistrySpecBuilder(ApicurioRegistrySpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ApicurioRegistrySpecBuilder(ApicurioRegistrySpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ApicurioRegistrySpec(), validationEnabled);
  }
  public ApicurioRegistrySpecBuilder(ApicurioRegistrySpecFluent<?> fluent,ApicurioRegistrySpec instance) {
    this(fluent, instance, false);
  }
  public ApicurioRegistrySpecBuilder(ApicurioRegistrySpecFluent<?> fluent,ApicurioRegistrySpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ApicurioRegistrySpec());

    if (instance != null) {
      fluent.withConfiguration(instance.getConfiguration());
      fluent.withDeployment(instance.getDeployment());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ApicurioRegistrySpecBuilder(ApicurioRegistrySpec instance) {
    this(instance,false);
  }
  public ApicurioRegistrySpecBuilder(ApicurioRegistrySpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ApicurioRegistrySpec());

    if (instance != null) {
      this.withConfiguration(instance.getConfiguration());
      this.withDeployment(instance.getDeployment());
    }
    this.validationEnabled = validationEnabled; 
  }
  ApicurioRegistrySpecFluent<?> fluent;
  Boolean validationEnabled;
  public ApicurioRegistrySpec build() {
    ApicurioRegistrySpec buildable = new ApicurioRegistrySpec();
    buildable.setConfiguration(fluent.buildConfiguration());
    buildable.setDeployment(fluent.buildDeployment());
    return buildable;
  }
  
}