package io.apicurio.registry.operator.api.v1.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ApicurioRegistryStatusBuilder extends ApicurioRegistryStatusFluent<ApicurioRegistryStatusBuilder> implements VisitableBuilder<ApicurioRegistryStatus,ApicurioRegistryStatusBuilder>{
  public ApicurioRegistryStatusBuilder() {
    this(false);
  }
  public ApicurioRegistryStatusBuilder(Boolean validationEnabled) {
    this(new ApicurioRegistryStatus(), validationEnabled);
  }
  public ApicurioRegistryStatusBuilder(ApicurioRegistryStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ApicurioRegistryStatusBuilder(ApicurioRegistryStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ApicurioRegistryStatus(), validationEnabled);
  }
  public ApicurioRegistryStatusBuilder(ApicurioRegistryStatusFluent<?> fluent,ApicurioRegistryStatus instance) {
    this(fluent, instance, false);
  }
  public ApicurioRegistryStatusBuilder(ApicurioRegistryStatusFluent<?> fluent,ApicurioRegistryStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ApicurioRegistryStatus());

    if (instance != null) {
      fluent.withConditions(instance.getConditions());
      fluent.withInfo(instance.getInfo());
      fluent.withManagedResources(instance.getManagedResources());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ApicurioRegistryStatusBuilder(ApicurioRegistryStatus instance) {
    this(instance,false);
  }
  public ApicurioRegistryStatusBuilder(ApicurioRegistryStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ApicurioRegistryStatus());

    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withInfo(instance.getInfo());
      this.withManagedResources(instance.getManagedResources());
    }
    this.validationEnabled = validationEnabled; 
  }
  ApicurioRegistryStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ApicurioRegistryStatus build() {
    ApicurioRegistryStatus buildable = new ApicurioRegistryStatus();
    buildable.setConditions(fluent.buildConditions());
    buildable.setInfo(fluent.buildInfo());
    buildable.setManagedResources(fluent.buildManagedResources());
    return buildable;
  }
  
}