package io.apicurio.registry.operator.api.v1.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.apicurio.registry.operator.api.v1.model.apicurioregistrystatus.InfoBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.apicurio.registry.operator.api.v1.model.apicurioregistrystatus.ConditionsFluent;
import io.apicurio.registry.operator.api.v1.model.apicurioregistrystatus.InfoFluent;
import java.lang.String;
import io.apicurio.registry.operator.api.v1.model.apicurioregistrystatus.Conditions;
import java.util.function.Predicate;
import io.apicurio.registry.operator.api.v1.model.apicurioregistrystatus.ManagedResourcesFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import io.apicurio.registry.operator.api.v1.model.apicurioregistrystatus.Info;
import io.apicurio.registry.operator.api.v1.model.apicurioregistrystatus.ConditionsBuilder;
import io.apicurio.registry.operator.api.v1.model.apicurioregistrystatus.ManagedResourcesBuilder;
import java.util.Collection;
import java.lang.Object;
import io.apicurio.registry.operator.api.v1.model.apicurioregistrystatus.ManagedResources;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ApicurioRegistryStatusFluent<A extends ApicurioRegistryStatusFluent<A>> extends BaseFluent<A>{
  public ApicurioRegistryStatusFluent() {
  }
  public ApicurioRegistryStatusFluent(ApicurioRegistryStatus instance) {
    instance = (instance != null ? instance : new ApicurioRegistryStatus());

    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withInfo(instance.getInfo());
      this.withManagedResources(instance.getManagedResources());
    }
  }
  private ArrayList<ConditionsBuilder> conditions;
  private InfoBuilder info;
  private ArrayList<ManagedResourcesBuilder> managedResources;
  public A addToConditions(int index,Conditions item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionsBuilder>();}
    ConditionsBuilder builder = new ConditionsBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").add(index, builder); conditions.add(index, builder);}
    return (A)this;
  }
  public A setToConditions(int index,Conditions item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionsBuilder>();}
    ConditionsBuilder builder = new ConditionsBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").set(index, builder); conditions.set(index, builder);}
    return (A)this;
  }
  public A addToConditions(io.apicurio.registry.operator.api.v1.model.apicurioregistrystatus.Conditions... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionsBuilder>();}
    for (Conditions item : items) {ConditionsBuilder builder = new ConditionsBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<Conditions> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionsBuilder>();}
    for (Conditions item : items) {ConditionsBuilder builder = new ConditionsBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.apicurio.registry.operator.api.v1.model.apicurioregistrystatus.Conditions... items) {
    if (this.conditions == null) return (A)this;
    for (Conditions item : items) {ConditionsBuilder builder = new ConditionsBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  public A removeAllFromConditions(Collection<Conditions> items) {
    if (this.conditions == null) return (A)this;
    for (Conditions item : items) {ConditionsBuilder builder = new ConditionsBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<ConditionsBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<ConditionsBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      ConditionsBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<Conditions> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public Conditions buildCondition(int index) {
    return this.conditions.get(index).build();
  }
  public Conditions buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public Conditions buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public Conditions buildMatchingCondition(Predicate<ConditionsBuilder> predicate) {
    for (ConditionsBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingCondition(Predicate<ConditionsBuilder> predicate) {
    for (ConditionsBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<Conditions> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").clear();}
    if (conditions != null) {this.conditions = new ArrayList(); for (Conditions item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.apicurio.registry.operator.api.v1.model.apicurioregistrystatus.Conditions... conditions) {
    if (this.conditions != null) {this.conditions.clear(); _visitables.remove("conditions"); }
    if (conditions != null) {for (Conditions item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public ConditionsNested<A> addNewCondition() {
    return new ConditionsNested(-1, null);
  }
  public ConditionsNested<A> addNewConditionLike(Conditions item) {
    return new ConditionsNested(-1, item);
  }
  public ConditionsNested<A> setNewConditionLike(int index,Conditions item) {
    return new ConditionsNested(index, item);
  }
  public ConditionsNested<A> editCondition(int index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public ConditionsNested<A> editMatchingCondition(Predicate<ConditionsBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public Info buildInfo() {
    return this.info!=null ?this.info.build():null;
  }
  public A withInfo(Info info) {
    _visitables.get("info").remove(this.info);
    if (info!=null){ this.info= new InfoBuilder(info); _visitables.get("info").add(this.info);} else { this.info = null; _visitables.get("info").remove(this.info); } return (A) this;
  }
  public boolean hasInfo() {
    return this.info != null;
  }
  public InfoNested<A> withNewInfo() {
    return new InfoNested(null);
  }
  public InfoNested<A> withNewInfoLike(Info item) {
    return new InfoNested(item);
  }
  public InfoNested<A> editInfo() {
    return withNewInfoLike(java.util.Optional.ofNullable(buildInfo()).orElse(null));
  }
  public InfoNested<A> editOrNewInfo() {
    return withNewInfoLike(java.util.Optional.ofNullable(buildInfo()).orElse(new InfoBuilder().build()));
  }
  public InfoNested<A> editOrNewInfoLike(Info item) {
    return withNewInfoLike(java.util.Optional.ofNullable(buildInfo()).orElse(item));
  }
  public A addToManagedResources(int index,ManagedResources item) {
    if (this.managedResources == null) {this.managedResources = new ArrayList<ManagedResourcesBuilder>();}
    ManagedResourcesBuilder builder = new ManagedResourcesBuilder(item);
    if (index < 0 || index >= managedResources.size()) { _visitables.get("managedResources").add(builder); managedResources.add(builder); } else { _visitables.get("managedResources").add(index, builder); managedResources.add(index, builder);}
    return (A)this;
  }
  public A setToManagedResources(int index,ManagedResources item) {
    if (this.managedResources == null) {this.managedResources = new ArrayList<ManagedResourcesBuilder>();}
    ManagedResourcesBuilder builder = new ManagedResourcesBuilder(item);
    if (index < 0 || index >= managedResources.size()) { _visitables.get("managedResources").add(builder); managedResources.add(builder); } else { _visitables.get("managedResources").set(index, builder); managedResources.set(index, builder);}
    return (A)this;
  }
  public A addToManagedResources(io.apicurio.registry.operator.api.v1.model.apicurioregistrystatus.ManagedResources... items) {
    if (this.managedResources == null) {this.managedResources = new ArrayList<ManagedResourcesBuilder>();}
    for (ManagedResources item : items) {ManagedResourcesBuilder builder = new ManagedResourcesBuilder(item);_visitables.get("managedResources").add(builder);this.managedResources.add(builder);} return (A)this;
  }
  public A addAllToApicurioregistrystatusManagedResources(Collection<ManagedResources> items) {
    if (this.managedResources == null) {this.managedResources = new ArrayList<ManagedResourcesBuilder>();}
    for (ManagedResources item : items) {ManagedResourcesBuilder builder = new ManagedResourcesBuilder(item);_visitables.get("managedResources").add(builder);this.managedResources.add(builder);} return (A)this;
  }
  public A removeFromManagedResources(io.apicurio.registry.operator.api.v1.model.apicurioregistrystatus.ManagedResources... items) {
    if (this.managedResources == null) return (A)this;
    for (ManagedResources item : items) {ManagedResourcesBuilder builder = new ManagedResourcesBuilder(item);_visitables.get("managedResources").remove(builder); this.managedResources.remove(builder);} return (A)this;
  }
  public A removeAllFromApicurioregistrystatusManagedResources(Collection<ManagedResources> items) {
    if (this.managedResources == null) return (A)this;
    for (ManagedResources item : items) {ManagedResourcesBuilder builder = new ManagedResourcesBuilder(item);_visitables.get("managedResources").remove(builder); this.managedResources.remove(builder);} return (A)this;
  }
  public A removeMatchingFromApicurioregistrystatusManagedResources(Predicate<ManagedResourcesBuilder> predicate) {
    if (managedResources == null) return (A) this;
    final Iterator<ManagedResourcesBuilder> each = managedResources.iterator();
    final List visitables = _visitables.get("managedResources");
    while (each.hasNext()) {
      ManagedResourcesBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<ManagedResources> buildManagedResources() {
    return managedResources != null ? build(managedResources) : null;
  }
  public ManagedResources buildManagedResource(int index) {
    return this.managedResources.get(index).build();
  }
  public ManagedResources buildFirstManagedResource() {
    return this.managedResources.get(0).build();
  }
  public ManagedResources buildLastManagedResource() {
    return this.managedResources.get(managedResources.size() - 1).build();
  }
  public ManagedResources buildMatchingManagedResource(Predicate<ManagedResourcesBuilder> predicate) {
    for (ManagedResourcesBuilder item: managedResources) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingManagedResource(Predicate<ManagedResourcesBuilder> predicate) {
    for (ManagedResourcesBuilder item: managedResources) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withManagedResources(List<ManagedResources> managedResources) {
    if (this.managedResources != null) { _visitables.get("managedResources").clear();}
    if (managedResources != null) {this.managedResources = new ArrayList(); for (ManagedResources item : managedResources){this.addToManagedResources(item);}} else { this.managedResources = null;} return (A) this;
  }
  public A withManagedResources(io.apicurio.registry.operator.api.v1.model.apicurioregistrystatus.ManagedResources... managedResources) {
    if (this.managedResources != null) {this.managedResources.clear(); _visitables.remove("managedResources"); }
    if (managedResources != null) {for (ManagedResources item :managedResources){ this.addToManagedResources(item);}} return (A) this;
  }
  public boolean hasManagedResources() {
    return managedResources != null && !managedResources.isEmpty();
  }
  public ApicurioregistrystatusManagedResourcesNested<A> addNewApicurioregistrystatusManagedResource() {
    return new ApicurioregistrystatusManagedResourcesNested(-1, null);
  }
  public ApicurioregistrystatusManagedResourcesNested<A> addNewManagedResourceLike(ManagedResources item) {
    return new ApicurioregistrystatusManagedResourcesNested(-1, item);
  }
  public ApicurioregistrystatusManagedResourcesNested<A> setNewManagedResourceLike(int index,ManagedResources item) {
    return new ApicurioregistrystatusManagedResourcesNested(index, item);
  }
  public ApicurioregistrystatusManagedResourcesNested<A> editManagedResource(int index) {
    if (managedResources.size() <= index) throw new RuntimeException("Can't edit managedResources. Index exceeds size.");
    return setNewManagedResourceLike(index, buildManagedResource(index));
  }
  public ApicurioregistrystatusManagedResourcesNested<A> editFirstManagedResource() {
    if (managedResources.size() == 0) throw new RuntimeException("Can't edit first managedResources. The list is empty.");
    return setNewManagedResourceLike(0, buildManagedResource(0));
  }
  public ApicurioregistrystatusManagedResourcesNested<A> editLastManagedResource() {
    int index = managedResources.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last managedResources. The list is empty.");
    return setNewManagedResourceLike(index, buildManagedResource(index));
  }
  public ApicurioregistrystatusManagedResourcesNested<A> editMatchingManagedResource(Predicate<ManagedResourcesBuilder> predicate) {
    int index = -1;
    for (int i=0;i<managedResources.size();i++) { 
    if (predicate.test(managedResources.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching managedResources. No match found.");
    return setNewManagedResourceLike(index, buildManagedResource(index));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ApicurioRegistryStatusFluent that = (ApicurioRegistryStatusFluent) o;
    if (!java.util.Objects.equals(conditions, that.conditions)) return false;

    if (!java.util.Objects.equals(info, that.info)) return false;

    if (!java.util.Objects.equals(managedResources, that.managedResources)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(conditions,  info,  managedResources,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (info != null) { sb.append("info:"); sb.append(info + ","); }
    if (managedResources != null && !managedResources.isEmpty()) { sb.append("managedResources:"); sb.append(managedResources); }
    sb.append("}");
    return sb.toString();
  }
  public class ConditionsNested<N> extends ConditionsFluent<ConditionsNested<N>> implements Nested<N>{
    ConditionsNested(int index,Conditions item) {
      this.index = index;
      this.builder = new ConditionsBuilder(this, item);
    }
    ConditionsBuilder builder;
    int index;
    public N and() {
      return (N) ApicurioRegistryStatusFluent.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  public class InfoNested<N> extends InfoFluent<InfoNested<N>> implements Nested<N>{
    InfoNested(Info item) {
      this.builder = new InfoBuilder(this, item);
    }
    InfoBuilder builder;
    public N and() {
      return (N) ApicurioRegistryStatusFluent.this.withInfo(builder.build());
    }
    public N endInfo() {
      return and();
    }
    
  }
  public class ApicurioregistrystatusManagedResourcesNested<N> extends ManagedResourcesFluent<ApicurioregistrystatusManagedResourcesNested<N>> implements Nested<N>{
    ApicurioregistrystatusManagedResourcesNested(int index,ManagedResources item) {
      this.index = index;
      this.builder = new ManagedResourcesBuilder(this, item);
    }
    ManagedResourcesBuilder builder;
    int index;
    public N and() {
      return (N) ApicurioRegistryStatusFluent.this.setToManagedResources(index,builder.build());
    }
    public N endApicurioregistrystatusManagedResource() {
      return and();
    }
    
  }
  
}