package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConfigurationBuilder extends ConfigurationFluent<ConfigurationBuilder> implements VisitableBuilder<Configuration,ConfigurationBuilder>{
  public ConfigurationBuilder() {
    this(false);
  }
  public ConfigurationBuilder(Boolean validationEnabled) {
    this(new Configuration(), validationEnabled);
  }
  public ConfigurationBuilder(ConfigurationFluent<?> fluent) {
    this(fluent, false);
  }
  public ConfigurationBuilder(ConfigurationFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Configuration(), validationEnabled);
  }
  public ConfigurationBuilder(ConfigurationFluent<?> fluent,Configuration instance) {
    this(fluent, instance, false);
  }
  public ConfigurationBuilder(ConfigurationFluent<?> fluent,Configuration instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Configuration());

    if (instance != null) {
      fluent.withEnv(instance.getEnv());
      fluent.withKafkasql(instance.getKafkasql());
      fluent.withLogLevel(instance.getLogLevel());
      fluent.withPersistence(instance.getPersistence());
      fluent.withRegistryLogLevel(instance.getRegistryLogLevel());
      fluent.withSecurity(instance.getSecurity());
      fluent.withSql(instance.getSql());
      fluent.withUi(instance.getUi());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ConfigurationBuilder(Configuration instance) {
    this(instance,false);
  }
  public ConfigurationBuilder(Configuration instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Configuration());

    if (instance != null) {
      this.withEnv(instance.getEnv());
      this.withKafkasql(instance.getKafkasql());
      this.withLogLevel(instance.getLogLevel());
      this.withPersistence(instance.getPersistence());
      this.withRegistryLogLevel(instance.getRegistryLogLevel());
      this.withSecurity(instance.getSecurity());
      this.withSql(instance.getSql());
      this.withUi(instance.getUi());
    }
    this.validationEnabled = validationEnabled; 
  }
  ConfigurationFluent<?> fluent;
  Boolean validationEnabled;
  public Configuration build() {
    Configuration buildable = new Configuration();
    buildable.setEnv(fluent.buildEnv());
    buildable.setKafkasql(fluent.buildKafkasql());
    buildable.setLogLevel(fluent.getLogLevel());
    buildable.setPersistence(fluent.getPersistence());
    buildable.setRegistryLogLevel(fluent.getRegistryLogLevel());
    buildable.setSecurity(fluent.buildSecurity());
    buildable.setSql(fluent.buildSql());
    buildable.setUi(fluent.buildUi());
    return buildable;
  }
  
}