package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.configuration.Env;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.configuration.Security;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.configuration.SqlBuilder;
import java.util.function.Predicate;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.configuration.SecurityFluent;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.configuration.UiBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.configuration.Kafkasql;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.configuration.EnvFluent;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.configuration.KafkasqlBuilder;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.configuration.Sql;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.configuration.EnvBuilder;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.configuration.Ui;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.configuration.KafkasqlFluent;
import java.util.Collection;
import java.lang.Object;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.configuration.SqlFluent;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.configuration.UiFluent;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.configuration.SecurityBuilder;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ConfigurationFluent<A extends ConfigurationFluent<A>> extends BaseFluent<A>{
  public ConfigurationFluent() {
  }
  public ConfigurationFluent(Configuration instance) {
    instance = (instance != null ? instance : new Configuration());

    if (instance != null) {
      this.withEnv(instance.getEnv());
      this.withKafkasql(instance.getKafkasql());
      this.withLogLevel(instance.getLogLevel());
      this.withPersistence(instance.getPersistence());
      this.withRegistryLogLevel(instance.getRegistryLogLevel());
      this.withSecurity(instance.getSecurity());
      this.withSql(instance.getSql());
      this.withUi(instance.getUi());
    }
  }
  private ArrayList<EnvBuilder> env;
  private KafkasqlBuilder kafkasql;
  private String logLevel;
  private String persistence;
  private String registryLogLevel;
  private SecurityBuilder security;
  private SqlBuilder sql;
  private UiBuilder ui;
  public A addToEnv(int index,Env item) {
    if (this.env == null) {this.env = new ArrayList<EnvBuilder>();}
    EnvBuilder builder = new EnvBuilder(item);
    if (index < 0 || index >= env.size()) { _visitables.get("env").add(builder); env.add(builder); } else { _visitables.get("env").add(index, builder); env.add(index, builder);}
    return (A)this;
  }
  public A setToEnv(int index,Env item) {
    if (this.env == null) {this.env = new ArrayList<EnvBuilder>();}
    EnvBuilder builder = new EnvBuilder(item);
    if (index < 0 || index >= env.size()) { _visitables.get("env").add(builder); env.add(builder); } else { _visitables.get("env").set(index, builder); env.set(index, builder);}
    return (A)this;
  }
  public A addToEnv(io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.configuration.Env... items) {
    if (this.env == null) {this.env = new ArrayList<EnvBuilder>();}
    for (Env item : items) {EnvBuilder builder = new EnvBuilder(item);_visitables.get("env").add(builder);this.env.add(builder);} return (A)this;
  }
  public A addAllToEnv(Collection<Env> items) {
    if (this.env == null) {this.env = new ArrayList<EnvBuilder>();}
    for (Env item : items) {EnvBuilder builder = new EnvBuilder(item);_visitables.get("env").add(builder);this.env.add(builder);} return (A)this;
  }
  public A removeFromEnv(io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.configuration.Env... items) {
    if (this.env == null) return (A)this;
    for (Env item : items) {EnvBuilder builder = new EnvBuilder(item);_visitables.get("env").remove(builder); this.env.remove(builder);} return (A)this;
  }
  public A removeAllFromEnv(Collection<Env> items) {
    if (this.env == null) return (A)this;
    for (Env item : items) {EnvBuilder builder = new EnvBuilder(item);_visitables.get("env").remove(builder); this.env.remove(builder);} return (A)this;
  }
  public A removeMatchingFromEnv(Predicate<EnvBuilder> predicate) {
    if (env == null) return (A) this;
    final Iterator<EnvBuilder> each = env.iterator();
    final List visitables = _visitables.get("env");
    while (each.hasNext()) {
      EnvBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<Env> buildEnv() {
    return env != null ? build(env) : null;
  }
  public Env buildEnv(int index) {
    return this.env.get(index).build();
  }
  public Env buildFirstEnv() {
    return this.env.get(0).build();
  }
  public Env buildLastEnv() {
    return this.env.get(env.size() - 1).build();
  }
  public Env buildMatchingEnv(Predicate<EnvBuilder> predicate) {
    for (EnvBuilder item: env) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingEnv(Predicate<EnvBuilder> predicate) {
    for (EnvBuilder item: env) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withEnv(List<Env> env) {
    if (this.env != null) { _visitables.get("env").clear();}
    if (env != null) {this.env = new ArrayList(); for (Env item : env){this.addToEnv(item);}} else { this.env = null;} return (A) this;
  }
  public A withEnv(io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.configuration.Env... env) {
    if (this.env != null) {this.env.clear(); _visitables.remove("env"); }
    if (env != null) {for (Env item :env){ this.addToEnv(item);}} return (A) this;
  }
  public boolean hasEnv() {
    return env != null && !env.isEmpty();
  }
  public EnvNested<A> addNewEnv() {
    return new EnvNested(-1, null);
  }
  public EnvNested<A> addNewEnvLike(Env item) {
    return new EnvNested(-1, item);
  }
  public EnvNested<A> setNewEnvLike(int index,Env item) {
    return new EnvNested(index, item);
  }
  public EnvNested<A> editEnv(int index) {
    if (env.size() <= index) throw new RuntimeException("Can't edit env. Index exceeds size.");
    return setNewEnvLike(index, buildEnv(index));
  }
  public EnvNested<A> editFirstEnv() {
    if (env.size() == 0) throw new RuntimeException("Can't edit first env. The list is empty.");
    return setNewEnvLike(0, buildEnv(0));
  }
  public EnvNested<A> editLastEnv() {
    int index = env.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last env. The list is empty.");
    return setNewEnvLike(index, buildEnv(index));
  }
  public EnvNested<A> editMatchingEnv(Predicate<EnvBuilder> predicate) {
    int index = -1;
    for (int i=0;i<env.size();i++) { 
    if (predicate.test(env.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching env. No match found.");
    return setNewEnvLike(index, buildEnv(index));
  }
  public Kafkasql buildKafkasql() {
    return this.kafkasql!=null ?this.kafkasql.build():null;
  }
  public A withKafkasql(Kafkasql kafkasql) {
    _visitables.get("kafkasql").remove(this.kafkasql);
    if (kafkasql!=null){ this.kafkasql= new KafkasqlBuilder(kafkasql); _visitables.get("kafkasql").add(this.kafkasql);} else { this.kafkasql = null; _visitables.get("kafkasql").remove(this.kafkasql); } return (A) this;
  }
  public boolean hasKafkasql() {
    return this.kafkasql != null;
  }
  public KafkasqlNested<A> withNewKafkasql() {
    return new KafkasqlNested(null);
  }
  public KafkasqlNested<A> withNewKafkasqlLike(Kafkasql item) {
    return new KafkasqlNested(item);
  }
  public KafkasqlNested<A> editKafkasql() {
    return withNewKafkasqlLike(java.util.Optional.ofNullable(buildKafkasql()).orElse(null));
  }
  public KafkasqlNested<A> editOrNewKafkasql() {
    return withNewKafkasqlLike(java.util.Optional.ofNullable(buildKafkasql()).orElse(new KafkasqlBuilder().build()));
  }
  public KafkasqlNested<A> editOrNewKafkasqlLike(Kafkasql item) {
    return withNewKafkasqlLike(java.util.Optional.ofNullable(buildKafkasql()).orElse(item));
  }
  public String getLogLevel() {
    return this.logLevel;
  }
  public A withLogLevel(String logLevel) {
    this.logLevel=logLevel; return (A) this;
  }
  public boolean hasLogLevel() {
    return this.logLevel != null;
  }
  public String getPersistence() {
    return this.persistence;
  }
  public A withPersistence(String persistence) {
    this.persistence=persistence; return (A) this;
  }
  public boolean hasPersistence() {
    return this.persistence != null;
  }
  public String getRegistryLogLevel() {
    return this.registryLogLevel;
  }
  public A withRegistryLogLevel(String registryLogLevel) {
    this.registryLogLevel=registryLogLevel; return (A) this;
  }
  public boolean hasRegistryLogLevel() {
    return this.registryLogLevel != null;
  }
  public Security buildSecurity() {
    return this.security!=null ?this.security.build():null;
  }
  public A withSecurity(Security security) {
    _visitables.get("security").remove(this.security);
    if (security!=null){ this.security= new SecurityBuilder(security); _visitables.get("security").add(this.security);} else { this.security = null; _visitables.get("security").remove(this.security); } return (A) this;
  }
  public boolean hasSecurity() {
    return this.security != null;
  }
  public SecurityNested<A> withNewSecurity() {
    return new SecurityNested(null);
  }
  public SecurityNested<A> withNewSecurityLike(Security item) {
    return new SecurityNested(item);
  }
  public SecurityNested<A> editSecurity() {
    return withNewSecurityLike(java.util.Optional.ofNullable(buildSecurity()).orElse(null));
  }
  public SecurityNested<A> editOrNewSecurity() {
    return withNewSecurityLike(java.util.Optional.ofNullable(buildSecurity()).orElse(new SecurityBuilder().build()));
  }
  public SecurityNested<A> editOrNewSecurityLike(Security item) {
    return withNewSecurityLike(java.util.Optional.ofNullable(buildSecurity()).orElse(item));
  }
  public Sql buildSql() {
    return this.sql!=null ?this.sql.build():null;
  }
  public A withSql(Sql sql) {
    _visitables.get("sql").remove(this.sql);
    if (sql!=null){ this.sql= new SqlBuilder(sql); _visitables.get("sql").add(this.sql);} else { this.sql = null; _visitables.get("sql").remove(this.sql); } return (A) this;
  }
  public boolean hasSql() {
    return this.sql != null;
  }
  public SqlNested<A> withNewSql() {
    return new SqlNested(null);
  }
  public SqlNested<A> withNewSqlLike(Sql item) {
    return new SqlNested(item);
  }
  public SqlNested<A> editSql() {
    return withNewSqlLike(java.util.Optional.ofNullable(buildSql()).orElse(null));
  }
  public SqlNested<A> editOrNewSql() {
    return withNewSqlLike(java.util.Optional.ofNullable(buildSql()).orElse(new SqlBuilder().build()));
  }
  public SqlNested<A> editOrNewSqlLike(Sql item) {
    return withNewSqlLike(java.util.Optional.ofNullable(buildSql()).orElse(item));
  }
  public Ui buildUi() {
    return this.ui!=null ?this.ui.build():null;
  }
  public A withUi(Ui ui) {
    _visitables.get("ui").remove(this.ui);
    if (ui!=null){ this.ui= new UiBuilder(ui); _visitables.get("ui").add(this.ui);} else { this.ui = null; _visitables.get("ui").remove(this.ui); } return (A) this;
  }
  public boolean hasUi() {
    return this.ui != null;
  }
  public UiNested<A> withNewUi() {
    return new UiNested(null);
  }
  public UiNested<A> withNewUiLike(Ui item) {
    return new UiNested(item);
  }
  public UiNested<A> editUi() {
    return withNewUiLike(java.util.Optional.ofNullable(buildUi()).orElse(null));
  }
  public UiNested<A> editOrNewUi() {
    return withNewUiLike(java.util.Optional.ofNullable(buildUi()).orElse(new UiBuilder().build()));
  }
  public UiNested<A> editOrNewUiLike(Ui item) {
    return withNewUiLike(java.util.Optional.ofNullable(buildUi()).orElse(item));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ConfigurationFluent that = (ConfigurationFluent) o;
    if (!java.util.Objects.equals(env, that.env)) return false;

    if (!java.util.Objects.equals(kafkasql, that.kafkasql)) return false;

    if (!java.util.Objects.equals(logLevel, that.logLevel)) return false;

    if (!java.util.Objects.equals(persistence, that.persistence)) return false;

    if (!java.util.Objects.equals(registryLogLevel, that.registryLogLevel)) return false;

    if (!java.util.Objects.equals(security, that.security)) return false;

    if (!java.util.Objects.equals(sql, that.sql)) return false;

    if (!java.util.Objects.equals(ui, that.ui)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(env,  kafkasql,  logLevel,  persistence,  registryLogLevel,  security,  sql,  ui,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (env != null && !env.isEmpty()) { sb.append("env:"); sb.append(env + ","); }
    if (kafkasql != null) { sb.append("kafkasql:"); sb.append(kafkasql + ","); }
    if (logLevel != null) { sb.append("logLevel:"); sb.append(logLevel + ","); }
    if (persistence != null) { sb.append("persistence:"); sb.append(persistence + ","); }
    if (registryLogLevel != null) { sb.append("registryLogLevel:"); sb.append(registryLogLevel + ","); }
    if (security != null) { sb.append("security:"); sb.append(security + ","); }
    if (sql != null) { sb.append("sql:"); sb.append(sql + ","); }
    if (ui != null) { sb.append("ui:"); sb.append(ui); }
    sb.append("}");
    return sb.toString();
  }
  public class EnvNested<N> extends EnvFluent<EnvNested<N>> implements Nested<N>{
    EnvNested(int index,Env item) {
      this.index = index;
      this.builder = new EnvBuilder(this, item);
    }
    EnvBuilder builder;
    int index;
    public N and() {
      return (N) ConfigurationFluent.this.setToEnv(index,builder.build());
    }
    public N endEnv() {
      return and();
    }
    
  }
  public class KafkasqlNested<N> extends KafkasqlFluent<KafkasqlNested<N>> implements Nested<N>{
    KafkasqlNested(Kafkasql item) {
      this.builder = new KafkasqlBuilder(this, item);
    }
    KafkasqlBuilder builder;
    public N and() {
      return (N) ConfigurationFluent.this.withKafkasql(builder.build());
    }
    public N endKafkasql() {
      return and();
    }
    
  }
  public class SecurityNested<N> extends SecurityFluent<SecurityNested<N>> implements Nested<N>{
    SecurityNested(Security item) {
      this.builder = new SecurityBuilder(this, item);
    }
    SecurityBuilder builder;
    public N and() {
      return (N) ConfigurationFluent.this.withSecurity(builder.build());
    }
    public N endSecurity() {
      return and();
    }
    
  }
  public class SqlNested<N> extends SqlFluent<SqlNested<N>> implements Nested<N>{
    SqlNested(Sql item) {
      this.builder = new SqlBuilder(this, item);
    }
    SqlBuilder builder;
    public N and() {
      return (N) ConfigurationFluent.this.withSql(builder.build());
    }
    public N endSql() {
      return and();
    }
    
  }
  public class UiNested<N> extends UiFluent<UiNested<N>> implements Nested<N>{
    UiNested(Ui item) {
      this.builder = new UiBuilder(this, item);
    }
    UiBuilder builder;
    public N and() {
      return (N) ConfigurationFluent.this.withUi(builder.build());
    }
    public N endUi() {
      return and();
    }
    
  }
  
}