package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DeploymentBuilder extends DeploymentFluent<DeploymentBuilder> implements VisitableBuilder<Deployment,DeploymentBuilder>{
  public DeploymentBuilder() {
    this(false);
  }
  public DeploymentBuilder(Boolean validationEnabled) {
    this(new Deployment(), validationEnabled);
  }
  public DeploymentBuilder(DeploymentFluent<?> fluent) {
    this(fluent, false);
  }
  public DeploymentBuilder(DeploymentFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Deployment(), validationEnabled);
  }
  public DeploymentBuilder(DeploymentFluent<?> fluent,Deployment instance) {
    this(fluent, instance, false);
  }
  public DeploymentBuilder(DeploymentFluent<?> fluent,Deployment instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Deployment());

    if (instance != null) {
      fluent.withAffinity(instance.getAffinity());
      fluent.withHost(instance.getHost());
      fluent.withImage(instance.getImage());
      fluent.withImagePullSecrets(instance.getImagePullSecrets());
      fluent.withManagedResources(instance.getManagedResources());
      fluent.withMetadata(instance.getMetadata());
      fluent.withPodTemplateSpecPreview(instance.getPodTemplateSpecPreview());
      fluent.withReplicas(instance.getReplicas());
      fluent.withTolerations(instance.getTolerations());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DeploymentBuilder(Deployment instance) {
    this(instance,false);
  }
  public DeploymentBuilder(Deployment instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Deployment());

    if (instance != null) {
      this.withAffinity(instance.getAffinity());
      this.withHost(instance.getHost());
      this.withImage(instance.getImage());
      this.withImagePullSecrets(instance.getImagePullSecrets());
      this.withManagedResources(instance.getManagedResources());
      this.withMetadata(instance.getMetadata());
      this.withPodTemplateSpecPreview(instance.getPodTemplateSpecPreview());
      this.withReplicas(instance.getReplicas());
      this.withTolerations(instance.getTolerations());
    }
    this.validationEnabled = validationEnabled; 
  }
  DeploymentFluent<?> fluent;
  Boolean validationEnabled;
  public Deployment build() {
    Deployment buildable = new Deployment();
    buildable.setAffinity(fluent.buildAffinity());
    buildable.setHost(fluent.getHost());
    buildable.setImage(fluent.getImage());
    buildable.setImagePullSecrets(fluent.buildImagePullSecrets());
    buildable.setManagedResources(fluent.buildManagedResources());
    buildable.setMetadata(fluent.buildMetadata());
    buildable.setPodTemplateSpecPreview(fluent.buildPodTemplateSpecPreview());
    buildable.setReplicas(fluent.getReplicas());
    buildable.setTolerations(fluent.buildTolerations());
    return buildable;
  }
  
}