package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.Tolerations;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.AffinityBuilder;
import java.lang.SuppressWarnings;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.MetadataFluent;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.TolerationsBuilder;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.Metadata;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.PodTemplateSpecPreviewBuilder;
import java.util.function.Predicate;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.ManagedResourcesFluent;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.TolerationsFluent;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.PodTemplateSpecPreview;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.MetadataBuilder;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.ImagePullSecretsFluent;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.ImagePullSecrets;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.ImagePullSecretsBuilder;
import java.lang.Integer;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.ManagedResourcesBuilder;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.AffinityFluent;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.Affinity;
import java.util.Collection;
import java.lang.Object;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.ManagedResources;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.PodTemplateSpecPreviewFluent;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class DeploymentFluent<A extends DeploymentFluent<A>> extends BaseFluent<A>{
  public DeploymentFluent() {
  }
  public DeploymentFluent(Deployment instance) {
    instance = (instance != null ? instance : new Deployment());

    if (instance != null) {
      this.withAffinity(instance.getAffinity());
      this.withHost(instance.getHost());
      this.withImage(instance.getImage());
      this.withImagePullSecrets(instance.getImagePullSecrets());
      this.withManagedResources(instance.getManagedResources());
      this.withMetadata(instance.getMetadata());
      this.withPodTemplateSpecPreview(instance.getPodTemplateSpecPreview());
      this.withReplicas(instance.getReplicas());
      this.withTolerations(instance.getTolerations());
    }
  }
  private AffinityBuilder affinity;
  private String host;
  private String image;
  private ArrayList<ImagePullSecretsBuilder> imagePullSecrets;
  private ManagedResourcesBuilder managedResources;
  private MetadataBuilder metadata;
  private PodTemplateSpecPreviewBuilder podTemplateSpecPreview;
  private Integer replicas;
  private ArrayList<TolerationsBuilder> tolerations;
  public Affinity buildAffinity() {
    return this.affinity!=null ?this.affinity.build():null;
  }
  public A withAffinity(Affinity affinity) {
    _visitables.get("affinity").remove(this.affinity);
    if (affinity!=null){ this.affinity= new AffinityBuilder(affinity); _visitables.get("affinity").add(this.affinity);} else { this.affinity = null; _visitables.get("affinity").remove(this.affinity); } return (A) this;
  }
  public boolean hasAffinity() {
    return this.affinity != null;
  }
  public AffinityNested<A> withNewAffinity() {
    return new AffinityNested(null);
  }
  public AffinityNested<A> withNewAffinityLike(Affinity item) {
    return new AffinityNested(item);
  }
  public AffinityNested<A> editAffinity() {
    return withNewAffinityLike(java.util.Optional.ofNullable(buildAffinity()).orElse(null));
  }
  public AffinityNested<A> editOrNewAffinity() {
    return withNewAffinityLike(java.util.Optional.ofNullable(buildAffinity()).orElse(new AffinityBuilder().build()));
  }
  public AffinityNested<A> editOrNewAffinityLike(Affinity item) {
    return withNewAffinityLike(java.util.Optional.ofNullable(buildAffinity()).orElse(item));
  }
  public String getHost() {
    return this.host;
  }
  public A withHost(String host) {
    this.host=host; return (A) this;
  }
  public boolean hasHost() {
    return this.host != null;
  }
  public String getImage() {
    return this.image;
  }
  public A withImage(String image) {
    this.image=image; return (A) this;
  }
  public boolean hasImage() {
    return this.image != null;
  }
  public A addToImagePullSecrets(int index,ImagePullSecrets item) {
    if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<ImagePullSecretsBuilder>();}
    ImagePullSecretsBuilder builder = new ImagePullSecretsBuilder(item);
    if (index < 0 || index >= imagePullSecrets.size()) { _visitables.get("imagePullSecrets").add(builder); imagePullSecrets.add(builder); } else { _visitables.get("imagePullSecrets").add(index, builder); imagePullSecrets.add(index, builder);}
    return (A)this;
  }
  public A setToImagePullSecrets(int index,ImagePullSecrets item) {
    if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<ImagePullSecretsBuilder>();}
    ImagePullSecretsBuilder builder = new ImagePullSecretsBuilder(item);
    if (index < 0 || index >= imagePullSecrets.size()) { _visitables.get("imagePullSecrets").add(builder); imagePullSecrets.add(builder); } else { _visitables.get("imagePullSecrets").set(index, builder); imagePullSecrets.set(index, builder);}
    return (A)this;
  }
  public A addToImagePullSecrets(io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.ImagePullSecrets... items) {
    if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<ImagePullSecretsBuilder>();}
    for (ImagePullSecrets item : items) {ImagePullSecretsBuilder builder = new ImagePullSecretsBuilder(item);_visitables.get("imagePullSecrets").add(builder);this.imagePullSecrets.add(builder);} return (A)this;
  }
  public A addAllToImagePullSecrets(Collection<ImagePullSecrets> items) {
    if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<ImagePullSecretsBuilder>();}
    for (ImagePullSecrets item : items) {ImagePullSecretsBuilder builder = new ImagePullSecretsBuilder(item);_visitables.get("imagePullSecrets").add(builder);this.imagePullSecrets.add(builder);} return (A)this;
  }
  public A removeFromImagePullSecrets(io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.ImagePullSecrets... items) {
    if (this.imagePullSecrets == null) return (A)this;
    for (ImagePullSecrets item : items) {ImagePullSecretsBuilder builder = new ImagePullSecretsBuilder(item);_visitables.get("imagePullSecrets").remove(builder); this.imagePullSecrets.remove(builder);} return (A)this;
  }
  public A removeAllFromImagePullSecrets(Collection<ImagePullSecrets> items) {
    if (this.imagePullSecrets == null) return (A)this;
    for (ImagePullSecrets item : items) {ImagePullSecretsBuilder builder = new ImagePullSecretsBuilder(item);_visitables.get("imagePullSecrets").remove(builder); this.imagePullSecrets.remove(builder);} return (A)this;
  }
  public A removeMatchingFromImagePullSecrets(Predicate<ImagePullSecretsBuilder> predicate) {
    if (imagePullSecrets == null) return (A) this;
    final Iterator<ImagePullSecretsBuilder> each = imagePullSecrets.iterator();
    final List visitables = _visitables.get("imagePullSecrets");
    while (each.hasNext()) {
      ImagePullSecretsBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<ImagePullSecrets> buildImagePullSecrets() {
    return imagePullSecrets != null ? build(imagePullSecrets) : null;
  }
  public ImagePullSecrets buildImagePullSecret(int index) {
    return this.imagePullSecrets.get(index).build();
  }
  public ImagePullSecrets buildFirstImagePullSecret() {
    return this.imagePullSecrets.get(0).build();
  }
  public ImagePullSecrets buildLastImagePullSecret() {
    return this.imagePullSecrets.get(imagePullSecrets.size() - 1).build();
  }
  public ImagePullSecrets buildMatchingImagePullSecret(Predicate<ImagePullSecretsBuilder> predicate) {
    for (ImagePullSecretsBuilder item: imagePullSecrets) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingImagePullSecret(Predicate<ImagePullSecretsBuilder> predicate) {
    for (ImagePullSecretsBuilder item: imagePullSecrets) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withImagePullSecrets(List<ImagePullSecrets> imagePullSecrets) {
    if (this.imagePullSecrets != null) { _visitables.get("imagePullSecrets").clear();}
    if (imagePullSecrets != null) {this.imagePullSecrets = new ArrayList(); for (ImagePullSecrets item : imagePullSecrets){this.addToImagePullSecrets(item);}} else { this.imagePullSecrets = null;} return (A) this;
  }
  public A withImagePullSecrets(io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.ImagePullSecrets... imagePullSecrets) {
    if (this.imagePullSecrets != null) {this.imagePullSecrets.clear(); _visitables.remove("imagePullSecrets"); }
    if (imagePullSecrets != null) {for (ImagePullSecrets item :imagePullSecrets){ this.addToImagePullSecrets(item);}} return (A) this;
  }
  public boolean hasImagePullSecrets() {
    return imagePullSecrets != null && !imagePullSecrets.isEmpty();
  }
  public ImagePullSecretsNested<A> addNewImagePullSecret() {
    return new ImagePullSecretsNested(-1, null);
  }
  public ImagePullSecretsNested<A> addNewImagePullSecretLike(ImagePullSecrets item) {
    return new ImagePullSecretsNested(-1, item);
  }
  public ImagePullSecretsNested<A> setNewImagePullSecretLike(int index,ImagePullSecrets item) {
    return new ImagePullSecretsNested(index, item);
  }
  public ImagePullSecretsNested<A> editImagePullSecret(int index) {
    if (imagePullSecrets.size() <= index) throw new RuntimeException("Can't edit imagePullSecrets. Index exceeds size.");
    return setNewImagePullSecretLike(index, buildImagePullSecret(index));
  }
  public ImagePullSecretsNested<A> editFirstImagePullSecret() {
    if (imagePullSecrets.size() == 0) throw new RuntimeException("Can't edit first imagePullSecrets. The list is empty.");
    return setNewImagePullSecretLike(0, buildImagePullSecret(0));
  }
  public ImagePullSecretsNested<A> editLastImagePullSecret() {
    int index = imagePullSecrets.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last imagePullSecrets. The list is empty.");
    return setNewImagePullSecretLike(index, buildImagePullSecret(index));
  }
  public ImagePullSecretsNested<A> editMatchingImagePullSecret(Predicate<ImagePullSecretsBuilder> predicate) {
    int index = -1;
    for (int i=0;i<imagePullSecrets.size();i++) { 
    if (predicate.test(imagePullSecrets.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching imagePullSecrets. No match found.");
    return setNewImagePullSecretLike(index, buildImagePullSecret(index));
  }
  public ManagedResources buildManagedResources() {
    return this.managedResources!=null ?this.managedResources.build():null;
  }
  public A withManagedResources(ManagedResources managedResources) {
    _visitables.get("managedResources").remove(this.managedResources);
    if (managedResources!=null){ this.managedResources= new ManagedResourcesBuilder(managedResources); _visitables.get("managedResources").add(this.managedResources);} else { this.managedResources = null; _visitables.get("managedResources").remove(this.managedResources); } return (A) this;
  }
  public boolean hasManagedResources() {
    return this.managedResources != null;
  }
  public ManagedResourcesNested<A> withNewManagedResources() {
    return new ManagedResourcesNested(null);
  }
  public ManagedResourcesNested<A> withNewManagedResourcesLike(ManagedResources item) {
    return new ManagedResourcesNested(item);
  }
  public ManagedResourcesNested<A> editManagedResources() {
    return withNewManagedResourcesLike(java.util.Optional.ofNullable(buildManagedResources()).orElse(null));
  }
  public ManagedResourcesNested<A> editOrNewManagedResources() {
    return withNewManagedResourcesLike(java.util.Optional.ofNullable(buildManagedResources()).orElse(new ManagedResourcesBuilder().build()));
  }
  public ManagedResourcesNested<A> editOrNewManagedResourcesLike(ManagedResources item) {
    return withNewManagedResourcesLike(java.util.Optional.ofNullable(buildManagedResources()).orElse(item));
  }
  public Metadata buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(Metadata metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new MetadataBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public boolean hasMetadata() {
    return this.metadata != null;
  }
  public MetadataNested<A> withNewMetadata() {
    return new MetadataNested(null);
  }
  public MetadataNested<A> withNewMetadataLike(Metadata item) {
    return new MetadataNested(item);
  }
  public MetadataNested<A> editMetadata() {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(null));
  }
  public MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(new MetadataBuilder().build()));
  }
  public MetadataNested<A> editOrNewMetadataLike(Metadata item) {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(item));
  }
  public PodTemplateSpecPreview buildPodTemplateSpecPreview() {
    return this.podTemplateSpecPreview!=null ?this.podTemplateSpecPreview.build():null;
  }
  public A withPodTemplateSpecPreview(PodTemplateSpecPreview podTemplateSpecPreview) {
    _visitables.get("podTemplateSpecPreview").remove(this.podTemplateSpecPreview);
    if (podTemplateSpecPreview!=null){ this.podTemplateSpecPreview= new PodTemplateSpecPreviewBuilder(podTemplateSpecPreview); _visitables.get("podTemplateSpecPreview").add(this.podTemplateSpecPreview);} else { this.podTemplateSpecPreview = null; _visitables.get("podTemplateSpecPreview").remove(this.podTemplateSpecPreview); } return (A) this;
  }
  public boolean hasPodTemplateSpecPreview() {
    return this.podTemplateSpecPreview != null;
  }
  public PodTemplateSpecPreviewNested<A> withNewPodTemplateSpecPreview() {
    return new PodTemplateSpecPreviewNested(null);
  }
  public PodTemplateSpecPreviewNested<A> withNewPodTemplateSpecPreviewLike(PodTemplateSpecPreview item) {
    return new PodTemplateSpecPreviewNested(item);
  }
  public PodTemplateSpecPreviewNested<A> editPodTemplateSpecPreview() {
    return withNewPodTemplateSpecPreviewLike(java.util.Optional.ofNullable(buildPodTemplateSpecPreview()).orElse(null));
  }
  public PodTemplateSpecPreviewNested<A> editOrNewPodTemplateSpecPreview() {
    return withNewPodTemplateSpecPreviewLike(java.util.Optional.ofNullable(buildPodTemplateSpecPreview()).orElse(new PodTemplateSpecPreviewBuilder().build()));
  }
  public PodTemplateSpecPreviewNested<A> editOrNewPodTemplateSpecPreviewLike(PodTemplateSpecPreview item) {
    return withNewPodTemplateSpecPreviewLike(java.util.Optional.ofNullable(buildPodTemplateSpecPreview()).orElse(item));
  }
  public Integer getReplicas() {
    return this.replicas;
  }
  public A withReplicas(Integer replicas) {
    this.replicas=replicas; return (A) this;
  }
  public boolean hasReplicas() {
    return this.replicas != null;
  }
  public A addToTolerations(int index,Tolerations item) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<TolerationsBuilder>();}
    TolerationsBuilder builder = new TolerationsBuilder(item);
    if (index < 0 || index >= tolerations.size()) { _visitables.get("tolerations").add(builder); tolerations.add(builder); } else { _visitables.get("tolerations").add(index, builder); tolerations.add(index, builder);}
    return (A)this;
  }
  public A setToTolerations(int index,Tolerations item) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<TolerationsBuilder>();}
    TolerationsBuilder builder = new TolerationsBuilder(item);
    if (index < 0 || index >= tolerations.size()) { _visitables.get("tolerations").add(builder); tolerations.add(builder); } else { _visitables.get("tolerations").set(index, builder); tolerations.set(index, builder);}
    return (A)this;
  }
  public A addToTolerations(io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.Tolerations... items) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<TolerationsBuilder>();}
    for (Tolerations item : items) {TolerationsBuilder builder = new TolerationsBuilder(item);_visitables.get("tolerations").add(builder);this.tolerations.add(builder);} return (A)this;
  }
  public A addAllToTolerations(Collection<Tolerations> items) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<TolerationsBuilder>();}
    for (Tolerations item : items) {TolerationsBuilder builder = new TolerationsBuilder(item);_visitables.get("tolerations").add(builder);this.tolerations.add(builder);} return (A)this;
  }
  public A removeFromTolerations(io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.Tolerations... items) {
    if (this.tolerations == null) return (A)this;
    for (Tolerations item : items) {TolerationsBuilder builder = new TolerationsBuilder(item);_visitables.get("tolerations").remove(builder); this.tolerations.remove(builder);} return (A)this;
  }
  public A removeAllFromTolerations(Collection<Tolerations> items) {
    if (this.tolerations == null) return (A)this;
    for (Tolerations item : items) {TolerationsBuilder builder = new TolerationsBuilder(item);_visitables.get("tolerations").remove(builder); this.tolerations.remove(builder);} return (A)this;
  }
  public A removeMatchingFromTolerations(Predicate<TolerationsBuilder> predicate) {
    if (tolerations == null) return (A) this;
    final Iterator<TolerationsBuilder> each = tolerations.iterator();
    final List visitables = _visitables.get("tolerations");
    while (each.hasNext()) {
      TolerationsBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<Tolerations> buildTolerations() {
    return tolerations != null ? build(tolerations) : null;
  }
  public Tolerations buildToleration(int index) {
    return this.tolerations.get(index).build();
  }
  public Tolerations buildFirstToleration() {
    return this.tolerations.get(0).build();
  }
  public Tolerations buildLastToleration() {
    return this.tolerations.get(tolerations.size() - 1).build();
  }
  public Tolerations buildMatchingToleration(Predicate<TolerationsBuilder> predicate) {
    for (TolerationsBuilder item: tolerations) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingToleration(Predicate<TolerationsBuilder> predicate) {
    for (TolerationsBuilder item: tolerations) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTolerations(List<Tolerations> tolerations) {
    if (this.tolerations != null) { _visitables.get("tolerations").clear();}
    if (tolerations != null) {this.tolerations = new ArrayList(); for (Tolerations item : tolerations){this.addToTolerations(item);}} else { this.tolerations = null;} return (A) this;
  }
  public A withTolerations(io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment.Tolerations... tolerations) {
    if (this.tolerations != null) {this.tolerations.clear(); _visitables.remove("tolerations"); }
    if (tolerations != null) {for (Tolerations item :tolerations){ this.addToTolerations(item);}} return (A) this;
  }
  public boolean hasTolerations() {
    return tolerations != null && !tolerations.isEmpty();
  }
  public TolerationsNested<A> addNewToleration() {
    return new TolerationsNested(-1, null);
  }
  public TolerationsNested<A> addNewTolerationLike(Tolerations item) {
    return new TolerationsNested(-1, item);
  }
  public TolerationsNested<A> setNewTolerationLike(int index,Tolerations item) {
    return new TolerationsNested(index, item);
  }
  public TolerationsNested<A> editToleration(int index) {
    if (tolerations.size() <= index) throw new RuntimeException("Can't edit tolerations. Index exceeds size.");
    return setNewTolerationLike(index, buildToleration(index));
  }
  public TolerationsNested<A> editFirstToleration() {
    if (tolerations.size() == 0) throw new RuntimeException("Can't edit first tolerations. The list is empty.");
    return setNewTolerationLike(0, buildToleration(0));
  }
  public TolerationsNested<A> editLastToleration() {
    int index = tolerations.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last tolerations. The list is empty.");
    return setNewTolerationLike(index, buildToleration(index));
  }
  public TolerationsNested<A> editMatchingToleration(Predicate<TolerationsBuilder> predicate) {
    int index = -1;
    for (int i=0;i<tolerations.size();i++) { 
    if (predicate.test(tolerations.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching tolerations. No match found.");
    return setNewTolerationLike(index, buildToleration(index));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DeploymentFluent that = (DeploymentFluent) o;
    if (!java.util.Objects.equals(affinity, that.affinity)) return false;

    if (!java.util.Objects.equals(host, that.host)) return false;

    if (!java.util.Objects.equals(image, that.image)) return false;

    if (!java.util.Objects.equals(imagePullSecrets, that.imagePullSecrets)) return false;

    if (!java.util.Objects.equals(managedResources, that.managedResources)) return false;

    if (!java.util.Objects.equals(metadata, that.metadata)) return false;

    if (!java.util.Objects.equals(podTemplateSpecPreview, that.podTemplateSpecPreview)) return false;

    if (!java.util.Objects.equals(replicas, that.replicas)) return false;

    if (!java.util.Objects.equals(tolerations, that.tolerations)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(affinity,  host,  image,  imagePullSecrets,  managedResources,  metadata,  podTemplateSpecPreview,  replicas,  tolerations,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (affinity != null) { sb.append("affinity:"); sb.append(affinity + ","); }
    if (host != null) { sb.append("host:"); sb.append(host + ","); }
    if (image != null) { sb.append("image:"); sb.append(image + ","); }
    if (imagePullSecrets != null && !imagePullSecrets.isEmpty()) { sb.append("imagePullSecrets:"); sb.append(imagePullSecrets + ","); }
    if (managedResources != null) { sb.append("managedResources:"); sb.append(managedResources + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (podTemplateSpecPreview != null) { sb.append("podTemplateSpecPreview:"); sb.append(podTemplateSpecPreview + ","); }
    if (replicas != null) { sb.append("replicas:"); sb.append(replicas + ","); }
    if (tolerations != null && !tolerations.isEmpty()) { sb.append("tolerations:"); sb.append(tolerations); }
    sb.append("}");
    return sb.toString();
  }
  public class AffinityNested<N> extends AffinityFluent<AffinityNested<N>> implements Nested<N>{
    AffinityNested(Affinity item) {
      this.builder = new AffinityBuilder(this, item);
    }
    AffinityBuilder builder;
    public N and() {
      return (N) DeploymentFluent.this.withAffinity(builder.build());
    }
    public N endAffinity() {
      return and();
    }
    
  }
  public class ImagePullSecretsNested<N> extends ImagePullSecretsFluent<ImagePullSecretsNested<N>> implements Nested<N>{
    ImagePullSecretsNested(int index,ImagePullSecrets item) {
      this.index = index;
      this.builder = new ImagePullSecretsBuilder(this, item);
    }
    ImagePullSecretsBuilder builder;
    int index;
    public N and() {
      return (N) DeploymentFluent.this.setToImagePullSecrets(index,builder.build());
    }
    public N endImagePullSecret() {
      return and();
    }
    
  }
  public class ManagedResourcesNested<N> extends ManagedResourcesFluent<ManagedResourcesNested<N>> implements Nested<N>{
    ManagedResourcesNested(ManagedResources item) {
      this.builder = new ManagedResourcesBuilder(this, item);
    }
    ManagedResourcesBuilder builder;
    public N and() {
      return (N) DeploymentFluent.this.withManagedResources(builder.build());
    }
    public N endManagedResources() {
      return and();
    }
    
  }
  public class MetadataNested<N> extends MetadataFluent<MetadataNested<N>> implements Nested<N>{
    MetadataNested(Metadata item) {
      this.builder = new MetadataBuilder(this, item);
    }
    MetadataBuilder builder;
    public N and() {
      return (N) DeploymentFluent.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  public class PodTemplateSpecPreviewNested<N> extends PodTemplateSpecPreviewFluent<PodTemplateSpecPreviewNested<N>> implements Nested<N>{
    PodTemplateSpecPreviewNested(PodTemplateSpecPreview item) {
      this.builder = new PodTemplateSpecPreviewBuilder(this, item);
    }
    PodTemplateSpecPreviewBuilder builder;
    public N and() {
      return (N) DeploymentFluent.this.withPodTemplateSpecPreview(builder.build());
    }
    public N endPodTemplateSpecPreview() {
      return and();
    }
    
  }
  public class TolerationsNested<N> extends TolerationsFluent<TolerationsNested<N>> implements Nested<N>{
    TolerationsNested(int index,Tolerations item) {
      this.index = index;
      this.builder = new TolerationsBuilder(this, item);
    }
    TolerationsBuilder builder;
    int index;
    public N and() {
      return (N) DeploymentFluent.this.setToTolerations(index,builder.build());
    }
    public N endToleration() {
      return and();
    }
    
  }
  
}