package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.configuration;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EnvBuilder extends EnvFluent<EnvBuilder> implements VisitableBuilder<Env,EnvBuilder>{
  public EnvBuilder() {
    this(false);
  }
  public EnvBuilder(Boolean validationEnabled) {
    this(new Env(), validationEnabled);
  }
  public EnvBuilder(EnvFluent<?> fluent) {
    this(fluent, false);
  }
  public EnvBuilder(EnvFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Env(), validationEnabled);
  }
  public EnvBuilder(EnvFluent<?> fluent,Env instance) {
    this(fluent, instance, false);
  }
  public EnvBuilder(EnvFluent<?> fluent,Env instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Env());

    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withValue(instance.getValue());
      fluent.withValueFrom(instance.getValueFrom());
    }
    this.validationEnabled = validationEnabled; 
  }
  public EnvBuilder(Env instance) {
    this(instance,false);
  }
  public EnvBuilder(Env instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Env());

    if (instance != null) {
      this.withName(instance.getName());
      this.withValue(instance.getValue());
      this.withValueFrom(instance.getValueFrom());
    }
    this.validationEnabled = validationEnabled; 
  }
  EnvFluent<?> fluent;
  Boolean validationEnabled;
  public Env build() {
    Env buildable = new Env();
    buildable.setName(fluent.getName());
    buildable.setValue(fluent.getValue());
    buildable.setValueFrom(fluent.buildValueFrom());
    return buildable;
  }
  
}