package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.configuration;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkasqlBuilder extends KafkasqlFluent<KafkasqlBuilder> implements VisitableBuilder<Kafkasql,KafkasqlBuilder>{
  public KafkasqlBuilder() {
    this(false);
  }
  public KafkasqlBuilder(Boolean validationEnabled) {
    this(new Kafkasql(), validationEnabled);
  }
  public KafkasqlBuilder(KafkasqlFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkasqlBuilder(KafkasqlFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Kafkasql(), validationEnabled);
  }
  public KafkasqlBuilder(KafkasqlFluent<?> fluent,Kafkasql instance) {
    this(fluent, instance, false);
  }
  public KafkasqlBuilder(KafkasqlFluent<?> fluent,Kafkasql instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Kafkasql());

    if (instance != null) {
      fluent.withBootstrapServers(instance.getBootstrapServers());
      fluent.withSecurity(instance.getSecurity());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkasqlBuilder(Kafkasql instance) {
    this(instance,false);
  }
  public KafkasqlBuilder(Kafkasql instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Kafkasql());

    if (instance != null) {
      this.withBootstrapServers(instance.getBootstrapServers());
      this.withSecurity(instance.getSecurity());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkasqlFluent<?> fluent;
  Boolean validationEnabled;
  public Kafkasql build() {
    Kafkasql buildable = new Kafkasql();
    buildable.setBootstrapServers(fluent.getBootstrapServers());
    buildable.setSecurity(fluent.buildSecurity());
    return buildable;
  }
  
}