package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.configuration;

import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.configuration.kafkasql.SecurityFluent;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Object;
import java.lang.String;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.configuration.kafkasql.Security;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.configuration.kafkasql.SecurityBuilder;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class KafkasqlFluent<A extends KafkasqlFluent<A>> extends BaseFluent<A>{
  public KafkasqlFluent() {
  }
  public KafkasqlFluent(Kafkasql instance) {
    instance = (instance != null ? instance : new Kafkasql());

    if (instance != null) {
      this.withBootstrapServers(instance.getBootstrapServers());
      this.withSecurity(instance.getSecurity());
    }
  }
  private String bootstrapServers;
  private SecurityBuilder security;
  public String getBootstrapServers() {
    return this.bootstrapServers;
  }
  public A withBootstrapServers(String bootstrapServers) {
    this.bootstrapServers=bootstrapServers; return (A) this;
  }
  public boolean hasBootstrapServers() {
    return this.bootstrapServers != null;
  }
  public Security buildSecurity() {
    return this.security!=null ?this.security.build():null;
  }
  public A withSecurity(Security security) {
    _visitables.get("security").remove(this.security);
    if (security!=null){ this.security= new SecurityBuilder(security); _visitables.get("security").add(this.security);} else { this.security = null; _visitables.get("security").remove(this.security); } return (A) this;
  }
  public boolean hasSecurity() {
    return this.security != null;
  }
  public KafkasqlSecurityNested<A> withNewKafkasqlSecurity() {
    return new KafkasqlSecurityNested(null);
  }
  public KafkasqlSecurityNested<A> withNewSecurityLike(Security item) {
    return new KafkasqlSecurityNested(item);
  }
  public KafkasqlSecurityNested<A> editKafkasqlSecurity() {
    return withNewSecurityLike(java.util.Optional.ofNullable(buildSecurity()).orElse(null));
  }
  public KafkasqlSecurityNested<A> editOrNewSecurity() {
    return withNewSecurityLike(java.util.Optional.ofNullable(buildSecurity()).orElse(new SecurityBuilder().build()));
  }
  public KafkasqlSecurityNested<A> editOrNewSecurityLike(Security item) {
    return withNewSecurityLike(java.util.Optional.ofNullable(buildSecurity()).orElse(item));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KafkasqlFluent that = (KafkasqlFluent) o;
    if (!java.util.Objects.equals(bootstrapServers, that.bootstrapServers)) return false;

    if (!java.util.Objects.equals(security, that.security)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(bootstrapServers,  security,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (bootstrapServers != null) { sb.append("bootstrapServers:"); sb.append(bootstrapServers + ","); }
    if (security != null) { sb.append("security:"); sb.append(security); }
    sb.append("}");
    return sb.toString();
  }
  public class KafkasqlSecurityNested<N> extends SecurityFluent<KafkasqlSecurityNested<N>> implements Nested<N>{
    KafkasqlSecurityNested(Security item) {
      this.builder = new SecurityBuilder(this, item);
    }
    SecurityBuilder builder;
    public N and() {
      return (N) KafkasqlFluent.this.withSecurity(builder.build());
    }
    public N endKafkasqlSecurity() {
      return and();
    }
    
  }
  
}