package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.configuration;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SecurityBuilder extends SecurityFluent<SecurityBuilder> implements VisitableBuilder<Security,SecurityBuilder>{
  public SecurityBuilder() {
    this(false);
  }
  public SecurityBuilder(Boolean validationEnabled) {
    this(new Security(), validationEnabled);
  }
  public SecurityBuilder(SecurityFluent<?> fluent) {
    this(fluent, false);
  }
  public SecurityBuilder(SecurityFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Security(), validationEnabled);
  }
  public SecurityBuilder(SecurityFluent<?> fluent,Security instance) {
    this(fluent, instance, false);
  }
  public SecurityBuilder(SecurityFluent<?> fluent,Security instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Security());

    if (instance != null) {
      fluent.withHttps(instance.getHttps());
      fluent.withKeycloak(instance.getKeycloak());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SecurityBuilder(Security instance) {
    this(instance,false);
  }
  public SecurityBuilder(Security instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Security());

    if (instance != null) {
      this.withHttps(instance.getHttps());
      this.withKeycloak(instance.getKeycloak());
    }
    this.validationEnabled = validationEnabled; 
  }
  SecurityFluent<?> fluent;
  Boolean validationEnabled;
  public Security build() {
    Security buildable = new Security();
    buildable.setHttps(fluent.buildHttps());
    buildable.setKeycloak(fluent.buildKeycloak());
    return buildable;
  }
  
}