package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.configuration;

import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.configuration.security.HttpsFluent;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.configuration.security.HttpsBuilder;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.configuration.security.Https;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.configuration.security.KeycloakFluent;
import java.lang.String;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.configuration.security.KeycloakBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.configuration.security.Keycloak;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class SecurityFluent<A extends SecurityFluent<A>> extends BaseFluent<A>{
  public SecurityFluent() {
  }
  public SecurityFluent(Security instance) {
    instance = (instance != null ? instance : new Security());

    if (instance != null) {
      this.withHttps(instance.getHttps());
      this.withKeycloak(instance.getKeycloak());
    }
  }
  private HttpsBuilder https;
  private KeycloakBuilder keycloak;
  public Https buildHttps() {
    return this.https!=null ?this.https.build():null;
  }
  public A withHttps(Https https) {
    _visitables.get("https").remove(this.https);
    if (https!=null){ this.https= new HttpsBuilder(https); _visitables.get("https").add(this.https);} else { this.https = null; _visitables.get("https").remove(this.https); } return (A) this;
  }
  public boolean hasHttps() {
    return this.https != null;
  }
  public HttpsNested<A> withNewHttps() {
    return new HttpsNested(null);
  }
  public HttpsNested<A> withNewHttpsLike(Https item) {
    return new HttpsNested(item);
  }
  public HttpsNested<A> editHttps() {
    return withNewHttpsLike(java.util.Optional.ofNullable(buildHttps()).orElse(null));
  }
  public HttpsNested<A> editOrNewHttps() {
    return withNewHttpsLike(java.util.Optional.ofNullable(buildHttps()).orElse(new HttpsBuilder().build()));
  }
  public HttpsNested<A> editOrNewHttpsLike(Https item) {
    return withNewHttpsLike(java.util.Optional.ofNullable(buildHttps()).orElse(item));
  }
  public Keycloak buildKeycloak() {
    return this.keycloak!=null ?this.keycloak.build():null;
  }
  public A withKeycloak(Keycloak keycloak) {
    _visitables.get("keycloak").remove(this.keycloak);
    if (keycloak!=null){ this.keycloak= new KeycloakBuilder(keycloak); _visitables.get("keycloak").add(this.keycloak);} else { this.keycloak = null; _visitables.get("keycloak").remove(this.keycloak); } return (A) this;
  }
  public boolean hasKeycloak() {
    return this.keycloak != null;
  }
  public KeycloakNested<A> withNewKeycloak() {
    return new KeycloakNested(null);
  }
  public KeycloakNested<A> withNewKeycloakLike(Keycloak item) {
    return new KeycloakNested(item);
  }
  public KeycloakNested<A> editKeycloak() {
    return withNewKeycloakLike(java.util.Optional.ofNullable(buildKeycloak()).orElse(null));
  }
  public KeycloakNested<A> editOrNewKeycloak() {
    return withNewKeycloakLike(java.util.Optional.ofNullable(buildKeycloak()).orElse(new KeycloakBuilder().build()));
  }
  public KeycloakNested<A> editOrNewKeycloakLike(Keycloak item) {
    return withNewKeycloakLike(java.util.Optional.ofNullable(buildKeycloak()).orElse(item));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SecurityFluent that = (SecurityFluent) o;
    if (!java.util.Objects.equals(https, that.https)) return false;

    if (!java.util.Objects.equals(keycloak, that.keycloak)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(https,  keycloak,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (https != null) { sb.append("https:"); sb.append(https + ","); }
    if (keycloak != null) { sb.append("keycloak:"); sb.append(keycloak); }
    sb.append("}");
    return sb.toString();
  }
  public class HttpsNested<N> extends HttpsFluent<HttpsNested<N>> implements Nested<N>{
    HttpsNested(Https item) {
      this.builder = new HttpsBuilder(this, item);
    }
    HttpsBuilder builder;
    public N and() {
      return (N) SecurityFluent.this.withHttps(builder.build());
    }
    public N endHttps() {
      return and();
    }
    
  }
  public class KeycloakNested<N> extends KeycloakFluent<KeycloakNested<N>> implements Nested<N>{
    KeycloakNested(Keycloak item) {
      this.builder = new KeycloakBuilder(this, item);
    }
    KeycloakBuilder builder;
    public N and() {
      return (N) SecurityFluent.this.withKeycloak(builder.build());
    }
    public N endKeycloak() {
      return and();
    }
    
  }
  
}