package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.configuration;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SqlBuilder extends SqlFluent<SqlBuilder> implements VisitableBuilder<Sql,SqlBuilder>{
  public SqlBuilder() {
    this(false);
  }
  public SqlBuilder(Boolean validationEnabled) {
    this(new Sql(), validationEnabled);
  }
  public SqlBuilder(SqlFluent<?> fluent) {
    this(fluent, false);
  }
  public SqlBuilder(SqlFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Sql(), validationEnabled);
  }
  public SqlBuilder(SqlFluent<?> fluent,Sql instance) {
    this(fluent, instance, false);
  }
  public SqlBuilder(SqlFluent<?> fluent,Sql instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Sql());

    if (instance != null) {
      fluent.withDataSource(instance.getDataSource());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SqlBuilder(Sql instance) {
    this(instance,false);
  }
  public SqlBuilder(Sql instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Sql());

    if (instance != null) {
      this.withDataSource(instance.getDataSource());
    }
    this.validationEnabled = validationEnabled; 
  }
  SqlFluent<?> fluent;
  Boolean validationEnabled;
  public Sql build() {
    Sql buildable = new Sql();
    buildable.setDataSource(fluent.buildDataSource());
    return buildable;
  }
  
}