package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.configuration;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class UiBuilder extends UiFluent<UiBuilder> implements VisitableBuilder<Ui,UiBuilder>{
  public UiBuilder() {
    this(false);
  }
  public UiBuilder(Boolean validationEnabled) {
    this(new Ui(), validationEnabled);
  }
  public UiBuilder(UiFluent<?> fluent) {
    this(fluent, false);
  }
  public UiBuilder(UiFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Ui(), validationEnabled);
  }
  public UiBuilder(UiFluent<?> fluent,Ui instance) {
    this(fluent, instance, false);
  }
  public UiBuilder(UiFluent<?> fluent,Ui instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Ui());

    if (instance != null) {
      fluent.withReadOnly(instance.getReadOnly());
    }
    this.validationEnabled = validationEnabled; 
  }
  public UiBuilder(Ui instance) {
    this(instance,false);
  }
  public UiBuilder(Ui instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Ui());

    if (instance != null) {
      this.withReadOnly(instance.getReadOnly());
    }
    this.validationEnabled = validationEnabled; 
  }
  UiFluent<?> fluent;
  Boolean validationEnabled;
  public Ui build() {
    Ui buildable = new Ui();
    buildable.setReadOnly(fluent.getReadOnly());
    return buildable;
  }
  
}