package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.configuration.env;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ValueFromBuilder extends ValueFromFluent<ValueFromBuilder> implements VisitableBuilder<ValueFrom,ValueFromBuilder>{
  public ValueFromBuilder() {
    this(false);
  }
  public ValueFromBuilder(Boolean validationEnabled) {
    this(new ValueFrom(), validationEnabled);
  }
  public ValueFromBuilder(ValueFromFluent<?> fluent) {
    this(fluent, false);
  }
  public ValueFromBuilder(ValueFromFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ValueFrom(), validationEnabled);
  }
  public ValueFromBuilder(ValueFromFluent<?> fluent,ValueFrom instance) {
    this(fluent, instance, false);
  }
  public ValueFromBuilder(ValueFromFluent<?> fluent,ValueFrom instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ValueFrom());

    if (instance != null) {
      fluent.withConfigMapKeyRef(instance.getConfigMapKeyRef());
      fluent.withFieldRef(instance.getFieldRef());
      fluent.withResourceFieldRef(instance.getResourceFieldRef());
      fluent.withSecretKeyRef(instance.getSecretKeyRef());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ValueFromBuilder(ValueFrom instance) {
    this(instance,false);
  }
  public ValueFromBuilder(ValueFrom instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ValueFrom());

    if (instance != null) {
      this.withConfigMapKeyRef(instance.getConfigMapKeyRef());
      this.withFieldRef(instance.getFieldRef());
      this.withResourceFieldRef(instance.getResourceFieldRef());
      this.withSecretKeyRef(instance.getSecretKeyRef());
    }
    this.validationEnabled = validationEnabled; 
  }
  ValueFromFluent<?> fluent;
  Boolean validationEnabled;
  public ValueFrom build() {
    ValueFrom buildable = new ValueFrom();
    buildable.setConfigMapKeyRef(fluent.buildConfigMapKeyRef());
    buildable.setFieldRef(fluent.buildFieldRef());
    buildable.setResourceFieldRef(fluent.buildResourceFieldRef());
    buildable.setSecretKeyRef(fluent.buildSecretKeyRef());
    return buildable;
  }
  
}