package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.configuration.env.valuefrom;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ResourceFieldRefBuilder extends ResourceFieldRefFluent<ResourceFieldRefBuilder> implements VisitableBuilder<ResourceFieldRef,ResourceFieldRefBuilder>{
  public ResourceFieldRefBuilder() {
    this(false);
  }
  public ResourceFieldRefBuilder(Boolean validationEnabled) {
    this(new ResourceFieldRef(), validationEnabled);
  }
  public ResourceFieldRefBuilder(ResourceFieldRefFluent<?> fluent) {
    this(fluent, false);
  }
  public ResourceFieldRefBuilder(ResourceFieldRefFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ResourceFieldRef(), validationEnabled);
  }
  public ResourceFieldRefBuilder(ResourceFieldRefFluent<?> fluent,ResourceFieldRef instance) {
    this(fluent, instance, false);
  }
  public ResourceFieldRefBuilder(ResourceFieldRefFluent<?> fluent,ResourceFieldRef instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ResourceFieldRef());

    if (instance != null) {
      fluent.withContainerName(instance.getContainerName());
      fluent.withDivisor(instance.getDivisor());
      fluent.withResource(instance.getResource());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ResourceFieldRefBuilder(ResourceFieldRef instance) {
    this(instance,false);
  }
  public ResourceFieldRefBuilder(ResourceFieldRef instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ResourceFieldRef());

    if (instance != null) {
      this.withContainerName(instance.getContainerName());
      this.withDivisor(instance.getDivisor());
      this.withResource(instance.getResource());
    }
    this.validationEnabled = validationEnabled; 
  }
  ResourceFieldRefFluent<?> fluent;
  Boolean validationEnabled;
  public ResourceFieldRef build() {
    ResourceFieldRef buildable = new ResourceFieldRef();
    buildable.setContainerName(fluent.getContainerName());
    buildable.setDivisor(fluent.getDivisor());
    buildable.setResource(fluent.getResource());
    return buildable;
  }
  
}