package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.configuration.kafkasql;

import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.configuration.kafkasql.security.ScramBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.configuration.kafkasql.security.TlsFluent;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.configuration.kafkasql.security.Scram;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.configuration.kafkasql.security.ScramFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.configuration.kafkasql.security.Tls;
import java.lang.Object;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.configuration.kafkasql.security.TlsBuilder;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class SecurityFluent<A extends SecurityFluent<A>> extends BaseFluent<A>{
  public SecurityFluent() {
  }
  public SecurityFluent(Security instance) {
    instance = (instance != null ? instance : new Security());

    if (instance != null) {
      this.withScram(instance.getScram());
      this.withTls(instance.getTls());
    }
  }
  private ScramBuilder scram;
  private TlsBuilder tls;
  public Scram buildScram() {
    return this.scram!=null ?this.scram.build():null;
  }
  public A withScram(Scram scram) {
    _visitables.get("scram").remove(this.scram);
    if (scram!=null){ this.scram= new ScramBuilder(scram); _visitables.get("scram").add(this.scram);} else { this.scram = null; _visitables.get("scram").remove(this.scram); } return (A) this;
  }
  public boolean hasScram() {
    return this.scram != null;
  }
  public ScramNested<A> withNewScram() {
    return new ScramNested(null);
  }
  public ScramNested<A> withNewScramLike(Scram item) {
    return new ScramNested(item);
  }
  public ScramNested<A> editScram() {
    return withNewScramLike(java.util.Optional.ofNullable(buildScram()).orElse(null));
  }
  public ScramNested<A> editOrNewScram() {
    return withNewScramLike(java.util.Optional.ofNullable(buildScram()).orElse(new ScramBuilder().build()));
  }
  public ScramNested<A> editOrNewScramLike(Scram item) {
    return withNewScramLike(java.util.Optional.ofNullable(buildScram()).orElse(item));
  }
  public Tls buildTls() {
    return this.tls!=null ?this.tls.build():null;
  }
  public A withTls(Tls tls) {
    _visitables.get("tls").remove(this.tls);
    if (tls!=null){ this.tls= new TlsBuilder(tls); _visitables.get("tls").add(this.tls);} else { this.tls = null; _visitables.get("tls").remove(this.tls); } return (A) this;
  }
  public boolean hasTls() {
    return this.tls != null;
  }
  public TlsNested<A> withNewTls() {
    return new TlsNested(null);
  }
  public TlsNested<A> withNewTlsLike(Tls item) {
    return new TlsNested(item);
  }
  public TlsNested<A> editTls() {
    return withNewTlsLike(java.util.Optional.ofNullable(buildTls()).orElse(null));
  }
  public TlsNested<A> editOrNewTls() {
    return withNewTlsLike(java.util.Optional.ofNullable(buildTls()).orElse(new TlsBuilder().build()));
  }
  public TlsNested<A> editOrNewTlsLike(Tls item) {
    return withNewTlsLike(java.util.Optional.ofNullable(buildTls()).orElse(item));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SecurityFluent that = (SecurityFluent) o;
    if (!java.util.Objects.equals(scram, that.scram)) return false;

    if (!java.util.Objects.equals(tls, that.tls)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(scram,  tls,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (scram != null) { sb.append("scram:"); sb.append(scram + ","); }
    if (tls != null) { sb.append("tls:"); sb.append(tls); }
    sb.append("}");
    return sb.toString();
  }
  public class ScramNested<N> extends ScramFluent<ScramNested<N>> implements Nested<N>{
    ScramNested(Scram item) {
      this.builder = new ScramBuilder(this, item);
    }
    ScramBuilder builder;
    public N and() {
      return (N) SecurityFluent.this.withScram(builder.build());
    }
    public N endScram() {
      return and();
    }
    
  }
  public class TlsNested<N> extends TlsFluent<TlsNested<N>> implements Nested<N>{
    TlsNested(Tls item) {
      this.builder = new TlsBuilder(this, item);
    }
    TlsBuilder builder;
    public N and() {
      return (N) SecurityFluent.this.withTls(builder.build());
    }
    public N endTls() {
      return and();
    }
    
  }
  
}