package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.configuration.kafkasql.security;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ScramBuilder extends ScramFluent<ScramBuilder> implements VisitableBuilder<Scram,ScramBuilder>{
  public ScramBuilder() {
    this(false);
  }
  public ScramBuilder(Boolean validationEnabled) {
    this(new Scram(), validationEnabled);
  }
  public ScramBuilder(ScramFluent<?> fluent) {
    this(fluent, false);
  }
  public ScramBuilder(ScramFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Scram(), validationEnabled);
  }
  public ScramBuilder(ScramFluent<?> fluent,Scram instance) {
    this(fluent, instance, false);
  }
  public ScramBuilder(ScramFluent<?> fluent,Scram instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Scram());

    if (instance != null) {
      fluent.withMechanism(instance.getMechanism());
      fluent.withPasswordSecretName(instance.getPasswordSecretName());
      fluent.withTruststoreSecretName(instance.getTruststoreSecretName());
      fluent.withUser(instance.getUser());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ScramBuilder(Scram instance) {
    this(instance,false);
  }
  public ScramBuilder(Scram instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Scram());

    if (instance != null) {
      this.withMechanism(instance.getMechanism());
      this.withPasswordSecretName(instance.getPasswordSecretName());
      this.withTruststoreSecretName(instance.getTruststoreSecretName());
      this.withUser(instance.getUser());
    }
    this.validationEnabled = validationEnabled; 
  }
  ScramFluent<?> fluent;
  Boolean validationEnabled;
  public Scram build() {
    Scram buildable = new Scram();
    buildable.setMechanism(fluent.getMechanism());
    buildable.setPasswordSecretName(fluent.getPasswordSecretName());
    buildable.setTruststoreSecretName(fluent.getTruststoreSecretName());
    buildable.setUser(fluent.getUser());
    return buildable;
  }
  
}