package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.configuration.kafkasql.security;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TlsBuilder extends TlsFluent<TlsBuilder> implements VisitableBuilder<Tls,TlsBuilder>{
  public TlsBuilder() {
    this(false);
  }
  public TlsBuilder(Boolean validationEnabled) {
    this(new Tls(), validationEnabled);
  }
  public TlsBuilder(TlsFluent<?> fluent) {
    this(fluent, false);
  }
  public TlsBuilder(TlsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Tls(), validationEnabled);
  }
  public TlsBuilder(TlsFluent<?> fluent,Tls instance) {
    this(fluent, instance, false);
  }
  public TlsBuilder(TlsFluent<?> fluent,Tls instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Tls());

    if (instance != null) {
      fluent.withKeystoreSecretName(instance.getKeystoreSecretName());
      fluent.withTruststoreSecretName(instance.getTruststoreSecretName());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TlsBuilder(Tls instance) {
    this(instance,false);
  }
  public TlsBuilder(Tls instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Tls());

    if (instance != null) {
      this.withKeystoreSecretName(instance.getKeystoreSecretName());
      this.withTruststoreSecretName(instance.getTruststoreSecretName());
    }
    this.validationEnabled = validationEnabled; 
  }
  TlsFluent<?> fluent;
  Boolean validationEnabled;
  public Tls build() {
    Tls buildable = new Tls();
    buildable.setKeystoreSecretName(fluent.getKeystoreSecretName());
    buildable.setTruststoreSecretName(fluent.getTruststoreSecretName());
    return buildable;
  }
  
}