package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.configuration.security;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HttpsBuilder extends HttpsFluent<HttpsBuilder> implements VisitableBuilder<Https,HttpsBuilder>{
  public HttpsBuilder() {
    this(false);
  }
  public HttpsBuilder(Boolean validationEnabled) {
    this(new Https(), validationEnabled);
  }
  public HttpsBuilder(HttpsFluent<?> fluent) {
    this(fluent, false);
  }
  public HttpsBuilder(HttpsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Https(), validationEnabled);
  }
  public HttpsBuilder(HttpsFluent<?> fluent,Https instance) {
    this(fluent, instance, false);
  }
  public HttpsBuilder(HttpsFluent<?> fluent,Https instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Https());

    if (instance != null) {
      fluent.withDisableHttp(instance.getDisableHttp());
      fluent.withSecretName(instance.getSecretName());
    }
    this.validationEnabled = validationEnabled; 
  }
  public HttpsBuilder(Https instance) {
    this(instance,false);
  }
  public HttpsBuilder(Https instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Https());

    if (instance != null) {
      this.withDisableHttp(instance.getDisableHttp());
      this.withSecretName(instance.getSecretName());
    }
    this.validationEnabled = validationEnabled; 
  }
  HttpsFluent<?> fluent;
  Boolean validationEnabled;
  public Https build() {
    Https buildable = new Https();
    buildable.setDisableHttp(fluent.getDisableHttp());
    buildable.setSecretName(fluent.getSecretName());
    return buildable;
  }
  
}