package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.configuration.security;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KeycloakBuilder extends KeycloakFluent<KeycloakBuilder> implements VisitableBuilder<Keycloak,KeycloakBuilder>{
  public KeycloakBuilder() {
    this(false);
  }
  public KeycloakBuilder(Boolean validationEnabled) {
    this(new Keycloak(), validationEnabled);
  }
  public KeycloakBuilder(KeycloakFluent<?> fluent) {
    this(fluent, false);
  }
  public KeycloakBuilder(KeycloakFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Keycloak(), validationEnabled);
  }
  public KeycloakBuilder(KeycloakFluent<?> fluent,Keycloak instance) {
    this(fluent, instance, false);
  }
  public KeycloakBuilder(KeycloakFluent<?> fluent,Keycloak instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Keycloak());

    if (instance != null) {
      fluent.withApiClientId(instance.getApiClientId());
      fluent.withRealm(instance.getRealm());
      fluent.withUiClientId(instance.getUiClientId());
      fluent.withUrl(instance.getUrl());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KeycloakBuilder(Keycloak instance) {
    this(instance,false);
  }
  public KeycloakBuilder(Keycloak instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Keycloak());

    if (instance != null) {
      this.withApiClientId(instance.getApiClientId());
      this.withRealm(instance.getRealm());
      this.withUiClientId(instance.getUiClientId());
      this.withUrl(instance.getUrl());
    }
    this.validationEnabled = validationEnabled; 
  }
  KeycloakFluent<?> fluent;
  Boolean validationEnabled;
  public Keycloak build() {
    Keycloak buildable = new Keycloak();
    buildable.setApiClientId(fluent.getApiClientId());
    buildable.setRealm(fluent.getRealm());
    buildable.setUiClientId(fluent.getUiClientId());
    buildable.setUrl(fluent.getUrl());
    return buildable;
  }
  
}