package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.configuration.security;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class KeycloakFluent<A extends KeycloakFluent<A>> extends BaseFluent<A>{
  public KeycloakFluent() {
  }
  public KeycloakFluent(Keycloak instance) {
    instance = (instance != null ? instance : new Keycloak());

    if (instance != null) {
      this.withApiClientId(instance.getApiClientId());
      this.withRealm(instance.getRealm());
      this.withUiClientId(instance.getUiClientId());
      this.withUrl(instance.getUrl());
    }
  }
  private String apiClientId;
  private String realm;
  private String uiClientId;
  private String url;
  public String getApiClientId() {
    return this.apiClientId;
  }
  public A withApiClientId(String apiClientId) {
    this.apiClientId=apiClientId; return (A) this;
  }
  public boolean hasApiClientId() {
    return this.apiClientId != null;
  }
  public String getRealm() {
    return this.realm;
  }
  public A withRealm(String realm) {
    this.realm=realm; return (A) this;
  }
  public boolean hasRealm() {
    return this.realm != null;
  }
  public String getUiClientId() {
    return this.uiClientId;
  }
  public A withUiClientId(String uiClientId) {
    this.uiClientId=uiClientId; return (A) this;
  }
  public boolean hasUiClientId() {
    return this.uiClientId != null;
  }
  public String getUrl() {
    return this.url;
  }
  public A withUrl(String url) {
    this.url=url; return (A) this;
  }
  public boolean hasUrl() {
    return this.url != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KeycloakFluent that = (KeycloakFluent) o;
    if (!java.util.Objects.equals(apiClientId, that.apiClientId)) return false;

    if (!java.util.Objects.equals(realm, that.realm)) return false;

    if (!java.util.Objects.equals(uiClientId, that.uiClientId)) return false;

    if (!java.util.Objects.equals(url, that.url)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiClientId,  realm,  uiClientId,  url,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiClientId != null) { sb.append("apiClientId:"); sb.append(apiClientId + ","); }
    if (realm != null) { sb.append("realm:"); sb.append(realm + ","); }
    if (uiClientId != null) { sb.append("uiClientId:"); sb.append(uiClientId + ","); }
    if (url != null) { sb.append("url:"); sb.append(url); }
    sb.append("}");
    return sb.toString();
  }
  
}