package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.configuration.sql;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DataSourceBuilder extends DataSourceFluent<DataSourceBuilder> implements VisitableBuilder<DataSource,DataSourceBuilder>{
  public DataSourceBuilder() {
    this(false);
  }
  public DataSourceBuilder(Boolean validationEnabled) {
    this(new DataSource(), validationEnabled);
  }
  public DataSourceBuilder(DataSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public DataSourceBuilder(DataSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DataSource(), validationEnabled);
  }
  public DataSourceBuilder(DataSourceFluent<?> fluent,DataSource instance) {
    this(fluent, instance, false);
  }
  public DataSourceBuilder(DataSourceFluent<?> fluent,DataSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new DataSource());

    if (instance != null) {
      fluent.withPassword(instance.getPassword());
      fluent.withUrl(instance.getUrl());
      fluent.withUserName(instance.getUserName());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DataSourceBuilder(DataSource instance) {
    this(instance,false);
  }
  public DataSourceBuilder(DataSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new DataSource());

    if (instance != null) {
      this.withPassword(instance.getPassword());
      this.withUrl(instance.getUrl());
      this.withUserName(instance.getUserName());
    }
    this.validationEnabled = validationEnabled; 
  }
  DataSourceFluent<?> fluent;
  Boolean validationEnabled;
  public DataSource build() {
    DataSource buildable = new DataSource();
    buildable.setPassword(fluent.getPassword());
    buildable.setUrl(fluent.getUrl());
    buildable.setUserName(fluent.getUserName());
    return buildable;
  }
  
}