package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AffinityBuilder extends AffinityFluent<AffinityBuilder> implements VisitableBuilder<Affinity,AffinityBuilder>{
  public AffinityBuilder() {
    this(false);
  }
  public AffinityBuilder(Boolean validationEnabled) {
    this(new Affinity(), validationEnabled);
  }
  public AffinityBuilder(AffinityFluent<?> fluent) {
    this(fluent, false);
  }
  public AffinityBuilder(AffinityFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Affinity(), validationEnabled);
  }
  public AffinityBuilder(AffinityFluent<?> fluent,Affinity instance) {
    this(fluent, instance, false);
  }
  public AffinityBuilder(AffinityFluent<?> fluent,Affinity instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Affinity());

    if (instance != null) {
      fluent.withNodeAffinity(instance.getNodeAffinity());
      fluent.withPodAffinity(instance.getPodAffinity());
      fluent.withPodAntiAffinity(instance.getPodAntiAffinity());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AffinityBuilder(Affinity instance) {
    this(instance,false);
  }
  public AffinityBuilder(Affinity instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Affinity());

    if (instance != null) {
      this.withNodeAffinity(instance.getNodeAffinity());
      this.withPodAffinity(instance.getPodAffinity());
      this.withPodAntiAffinity(instance.getPodAntiAffinity());
    }
    this.validationEnabled = validationEnabled; 
  }
  AffinityFluent<?> fluent;
  Boolean validationEnabled;
  public Affinity build() {
    Affinity buildable = new Affinity();
    buildable.setNodeAffinity(fluent.buildNodeAffinity());
    buildable.setPodAffinity(fluent.buildPodAffinity());
    buildable.setPodAntiAffinity(fluent.buildPodAntiAffinity());
    return buildable;
  }
  
}