package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImagePullSecretsBuilder extends ImagePullSecretsFluent<ImagePullSecretsBuilder> implements VisitableBuilder<ImagePullSecrets,ImagePullSecretsBuilder>{
  public ImagePullSecretsBuilder() {
    this(false);
  }
  public ImagePullSecretsBuilder(Boolean validationEnabled) {
    this(new ImagePullSecrets(), validationEnabled);
  }
  public ImagePullSecretsBuilder(ImagePullSecretsFluent<?> fluent) {
    this(fluent, false);
  }
  public ImagePullSecretsBuilder(ImagePullSecretsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ImagePullSecrets(), validationEnabled);
  }
  public ImagePullSecretsBuilder(ImagePullSecretsFluent<?> fluent,ImagePullSecrets instance) {
    this(fluent, instance, false);
  }
  public ImagePullSecretsBuilder(ImagePullSecretsFluent<?> fluent,ImagePullSecrets instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ImagePullSecrets());

    if (instance != null) {
      fluent.withName(instance.getName());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ImagePullSecretsBuilder(ImagePullSecrets instance) {
    this(instance,false);
  }
  public ImagePullSecretsBuilder(ImagePullSecrets instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ImagePullSecrets());

    if (instance != null) {
      this.withName(instance.getName());
    }
    this.validationEnabled = validationEnabled; 
  }
  ImagePullSecretsFluent<?> fluent;
  Boolean validationEnabled;
  public ImagePullSecrets build() {
    ImagePullSecrets buildable = new ImagePullSecrets();
    buildable.setName(fluent.getName());
    return buildable;
  }
  
}