package io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.deployment;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ManagedResourcesBuilder extends ManagedResourcesFluent<ManagedResourcesBuilder> implements VisitableBuilder<ManagedResources,ManagedResourcesBuilder>{
  public ManagedResourcesBuilder() {
    this(false);
  }
  public ManagedResourcesBuilder(Boolean validationEnabled) {
    this(new ManagedResources(), validationEnabled);
  }
  public ManagedResourcesBuilder(ManagedResourcesFluent<?> fluent) {
    this(fluent, false);
  }
  public ManagedResourcesBuilder(ManagedResourcesFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ManagedResources(), validationEnabled);
  }
  public ManagedResourcesBuilder(ManagedResourcesFluent<?> fluent,ManagedResources instance) {
    this(fluent, instance, false);
  }
  public ManagedResourcesBuilder(ManagedResourcesFluent<?> fluent,ManagedResources instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ManagedResources());

    if (instance != null) {
      fluent.withDisableIngress(instance.getDisableIngress());
      fluent.withDisableNetworkPolicy(instance.getDisableNetworkPolicy());
      fluent.withDisablePodDisruptionBudget(instance.getDisablePodDisruptionBudget());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ManagedResourcesBuilder(ManagedResources instance) {
    this(instance,false);
  }
  public ManagedResourcesBuilder(ManagedResources instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ManagedResources());

    if (instance != null) {
      this.withDisableIngress(instance.getDisableIngress());
      this.withDisableNetworkPolicy(instance.getDisableNetworkPolicy());
      this.withDisablePodDisruptionBudget(instance.getDisablePodDisruptionBudget());
    }
    this.validationEnabled = validationEnabled; 
  }
  ManagedResourcesFluent<?> fluent;
  Boolean validationEnabled;
  public ManagedResources build() {
    ManagedResources buildable = new ManagedResources();
    buildable.setDisableIngress(fluent.getDisableIngress());
    buildable.setDisableNetworkPolicy(fluent.getDisableNetworkPolicy());
    buildable.setDisablePodDisruptionBudget(fluent.getDisablePodDisruptionBudget());
    return buildable;
  }
  
}